/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.StackingModel;
import java.util.LinkedList;

public abstract class AbstractStacking
extends AbstractMetaLearner {
    public AbstractStacking(OperatorDescription description) {
        super(description);
    }

    public abstract String getModelName();

    public abstract Operator getStackingLearner() throws OperatorException;

    public abstract int getFirstBaseModelLearnerIndex();

    public abstract int getLastBaseModelLearnerIndex();

    public abstract boolean keepOldAttributes();

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Model> baseModels = new LinkedList<Model>();
        int i = this.getFirstBaseModelLearnerIndex();
        while (i <= this.getLastBaseModelLearnerIndex()) {
            Operator currentOperator = this.getOperator(i);
            IOContainer input = new IOContainer((ExampleSet)exampleSet.clone());
            input = currentOperator.apply(input);
            baseModels.add(input.remove(Model.class));
            ++i;
        }
        ExampleSet stackingLearningSet = (ExampleSet)exampleSet.clone();
        if (!this.keepOldAttributes()) {
            stackingLearningSet.getAttributes().clearRegular();
        }
        LinkedList<Attribute> tempPredictions = new LinkedList<Attribute>();
        int i2 = 0;
        for (Model baseModel : baseModels) {
            exampleSet = baseModel.apply(exampleSet);
            Attribute predictedLabel = exampleSet.getAttributes().getPredictedLabel();
            predictedLabel.setName("base_prediction" + i2);
            PredictionModel.removePredictedLabel(exampleSet, false, true);
            stackingLearningSet.getAttributes().addRegular(predictedLabel);
            tempPredictions.add(predictedLabel);
            ++i2;
        }
        Model stackingModel = this.getStackingLearner().apply(new IOContainer(stackingLearningSet)).remove(Model.class);
        PredictionModel.removePredictedLabel(stackingLearningSet);
        for (Attribute tempPrediction : tempPredictions) {
            stackingLearningSet.getAttributes().remove(tempPrediction);
            stackingLearningSet.getExampleTable().removeAttribute(tempPrediction);
        }
        return new StackingModel(exampleSet, this.getModelName(), baseModels, stackingModel, this.keepOldAttributes());
    }

    public boolean supportsCapability(LearnerCapability capability) {
        try {
            Operator learner = this.getStackingLearner();
            if (learner instanceof Learner) {
                return ((Learner)((Object)learner)).supportsCapability(capability);
            }
            return super.supportsCapability(capability);
        }
        catch (Exception e) {
            return super.supportsCapability(capability);
        }
    }
}

