/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.meta.MultiModelByRegression;

public class ClassificationByRegression
extends AbstractMetaLearner {
    private int numberOfClasses;

    public ClassificationByRegression(OperatorDescription description) {
        super(description);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_CLASS || lc == LearnerCapability.BINOMINAL_CLASS) {
            return true;
        }
        return super.supportsCapability(lc);
    }

    public Model learn(ExampleSet inputSet) throws OperatorException {
        Attribute classLabel = inputSet.getAttributes().getLabel();
        this.numberOfClasses = classLabel.getMapping().getValues().size();
        Model[] models = new Model[this.numberOfClasses];
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("temp_regression_label", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        eSet.getAttributes().setLabel(tempLabel);
        int i = 0;
        while (i < this.numberOfClasses) {
            for (Example e : eSet) {
                if (e.getValue(classLabel) == (double)i) {
                    e.setValue(tempLabel, 1.0);
                    continue;
                }
                e.setValue(tempLabel, -1.0);
            }
            models[i] = this.applyInnerLearner(eSet);
            this.inApplyLoop();
            ++i;
        }
        return new MultiModelByRegression(inputSet, models);
    }
}

