/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.meta;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVoteModel
extends SimplePredictionModel {
    private static final long serialVersionUID = 1089932073805038503L;
    private List<SimplePredictionModel> baseModels;

    public SimpleVoteModel(ExampleSet exampleSet, List<SimplePredictionModel> baseModels) {
        super(exampleSet);
        this.baseModels = baseModels;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        if (this.getLabel().isNominal()) {
            TreeMap<Double, AtomicInteger> classVotes = new TreeMap<Double, AtomicInteger>();
            Iterator<SimplePredictionModel> iterator = this.baseModels.iterator();
            while (iterator.hasNext()) {
                double prediction = iterator.next().predict(example);
                AtomicInteger counter = (AtomicInteger)classVotes.get(prediction);
                if (counter == null) {
                    classVotes.put(prediction, new AtomicInteger(1));
                    continue;
                }
                counter.incrementAndGet();
            }
            Iterator votedClasses = classVotes.keySet().iterator();
            LinkedList<Double> bestClasses = new LinkedList<Double>();
            int bestClassesVotes = -1;
            while (votedClasses.hasNext()) {
                double currentClass = (Double)votedClasses.next();
                int currentVotes = ((AtomicInteger)classVotes.get(currentClass)).intValue();
                if (currentVotes > bestClassesVotes) {
                    bestClasses.clear();
                    bestClasses.add(currentClass);
                    bestClassesVotes = currentVotes;
                }
                if (currentVotes == bestClassesVotes) {
                    bestClasses.add(currentClass);
                }
                example.setConfidence(this.getLabel().getMapping().mapIndex((int)currentClass), (double)currentVotes / (double)this.baseModels.size());
            }
            if (bestClasses.size() == 1) {
                return (Double)bestClasses.get(0);
            }
            return (Double)bestClasses.get(RandomGenerator.getGlobalRandomGenerator().nextInt(bestClasses.size()));
        }
        double sum = 0.0;
        Iterator<SimplePredictionModel> iterator = this.baseModels.iterator();
        while (iterator.hasNext()) {
            sum += iterator.next().predict(example);
        }
        return sum / (double)this.baseModels.size();
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        ExtendedJTabbedPane tabPane = new ExtendedJTabbedPane();
        int index = 1;
        for (Model model : this.baseModels) {
            tabPane.add("Model " + index, model.getVisualizationComponent(container));
            ++index;
        }
        return tabPane;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (SimplePredictionModel model : this.baseModels) {
            buffer.append("Model " + i + ":" + Tools.getLineSeparator());
            buffer.append("---" + Tools.getLineSeparator());
            buffer.append(model.toString());
            buffer.append(Tools.getLineSeparators(2));
            ++i;
        }
        return buffer.toString();
    }
}

