/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.ValueString;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.CombinationGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSubsetIteration
extends OperatorChain {
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";
    private int iteration = -1;
    private int featureNumber = -1;
    private String featureNames = null;

    public FeatureSubsetIteration(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The current iteration."){

            public double getDoubleValue() {
                return FeatureSubsetIteration.this.iteration;
            }
        });
        this.addValue(new ValueDouble("feature_number", "The number of used features in the current iteration."){

            public double getDoubleValue() {
                return FeatureSubsetIteration.this.featureNumber;
            }
        });
        this.addValue(new ValueString("feature_names", "The names of the used features in the current iteration."){

            public String getStringValue() {
                return FeatureSubsetIteration.this.featureNames;
            }
        });
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute[] allAttributes = exampleSet.getAttributes().createRegularAttributeArray();
        int minNumberOfFeatures = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumberOfFeatures = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
        int exactNumberOfFeatures = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
        if (exactNumberOfFeatures > 0) {
            this.log("Using exact number of features for feature subset iteration (" + exactNumberOfFeatures + "), ignoring possibly defined range for the number of features.");
        } else {
            if (maxNumberOfFeatures > 0 && minNumberOfFeatures > maxNumberOfFeatures) {
                throw new UserError((Operator)this, 210, PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
            }
            if (maxNumberOfFeatures > allAttributes.length) {
                throw new UserError((Operator)this, 207, String.valueOf(maxNumberOfFeatures), PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, " the parameter value must be smaller than the number of attributes of the input example set.");
            }
        }
        this.iteration = 0;
        this.featureNumber = 0;
        this.featureNames = "?";
        if (exactNumberOfFeatures > 0) {
            if (exactNumberOfFeatures > allAttributes.length) {
                throw new UserError((Operator)this, 207, String.valueOf(exactNumberOfFeatures), PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, " the parameter value must be larger than the number of attributes of the input example set.");
            }
            this.applyOnAllWithExactNumber(exampleSet, allAttributes, exactNumberOfFeatures);
        } else {
            this.applyOnAllInRange(exampleSet, allAttributes, minNumberOfFeatures, maxNumberOfFeatures);
        }
        return new IOObject[]{exampleSet};
    }

    private void applyInnerOperators(ExampleSet exampleSet) throws OperatorException {
        IOContainer input = new IOContainer(exampleSet);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
    }

    private void applyOnAllWithExactNumber(ExampleSet exampleSet, Attribute[] allAttributes, int exactNumberOfFeatures) throws OperatorException {
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        this.featureNumber = exactNumberOfFeatures;
        if (exactNumberOfFeatures == 1) {
            int i = 0;
            while (i < allAttributes.length) {
                workingSet.getAttributes().clearRegular();
                workingSet.getAttributes().addRegular(allAttributes[i]);
                ++this.iteration;
                this.featureNames = allAttributes[i].getName();
                this.applyInnerOperators(workingSet);
                ++i;
            }
        } else if (exactNumberOfFeatures == allAttributes.length) {
            StringBuffer nameBuffer = new StringBuffer();
            boolean first = true;
            workingSet.getAttributes().clearRegular();
            int i = 0;
            while (i < allAttributes.length) {
                Attribute attribute = allAttributes[i];
                workingSet.getAttributes().addRegular(attribute);
                if (!first) {
                    nameBuffer.append(", ");
                }
                nameBuffer.append(attribute.getName());
                first = false;
                ++i;
            }
            ++this.iteration;
            this.featureNames = nameBuffer.toString();
            this.applyInnerOperators(workingSet);
        } else {
            CombinationGenerator combinationGenerator = new CombinationGenerator(allAttributes.length, exactNumberOfFeatures);
            while (combinationGenerator.hasMore()) {
                int[] indices = combinationGenerator.getNext();
                StringBuffer nameBuffer = new StringBuffer();
                boolean first = true;
                workingSet.getAttributes().clearRegular();
                int i = 0;
                while (i < indices.length) {
                    Attribute attribute = allAttributes[indices[i]];
                    workingSet.getAttributes().addRegular(attribute);
                    if (!first) {
                        nameBuffer.append(", ");
                    }
                    nameBuffer.append(attribute.getName());
                    first = false;
                    ++i;
                }
                ++this.iteration;
                this.featureNames = nameBuffer.toString();
                this.applyInnerOperators(workingSet);
            }
        }
    }

    private void applyOnAllInRange(ExampleSet exampleSet, Attribute[] allAttributes, int minNumberOfFeatures, int maxNumberOfFeatures) throws OperatorException {
        int i = minNumberOfFeatures;
        while (i <= maxNumberOfFeatures) {
            this.applyOnAllWithExactNumber(exampleSet, allAttributes, i);
            ++i;
        }
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[0]);
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of features used for the combinations (-1: try all combinations up to possible maximum)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of features used for the combinations (-1: use the feature range defined by min and max).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

