/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.viewer.ConfusionMatrixViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiClassificationPerformance
extends MeasuredPerformance
implements Tableable {
    private static final long serialVersionUID = 3068421566038331525L;
    public static final int UNDEFINED = -1;
    public static final int ACCURACY = 0;
    public static final int ERROR = 1;
    public static final int KAPPA = 2;
    public static final String[] NAMES = new String[]{"accuracy", "classification_error", "kappa"};
    public static final String[] DESCRIPTIONS = new String[]{"Relative number of correctly classified examples", "Relative number of misclassified examples", "The kappa statistics for the classification"};
    private double[][] counter;
    private String[] classNames;
    private Map<String, Integer> classNameMap = new HashMap<String, Integer>();
    private Attribute labelAttribute;
    private Attribute predictedLabelAttribute;
    private Attribute weightAttribute;
    private int type = 0;
    private transient ConfusionMatrixViewer viewer;

    public MultiClassificationPerformance() {
        this(-1);
    }

    public MultiClassificationPerformance(int type) {
        this.type = type;
    }

    public MultiClassificationPerformance(MultiClassificationPerformance m) {
        super(m);
        this.type = m.type;
        this.classNames = new String[m.classNames.length];
        int i = 0;
        while (i < this.classNames.length) {
            this.classNames[i] = m.classNames[i];
            this.classNameMap.put(this.classNames[i], i);
            ++i;
        }
        this.counter = new double[m.counter.length][m.counter.length];
        i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                this.counter[i][j] = m.counter[i][j];
                ++j;
            }
            ++i;
        }
        this.labelAttribute = (Attribute)m.labelAttribute.clone();
        this.predictedLabelAttribute = (Attribute)m.predictedLabelAttribute.clone();
        if (m.weightAttribute != null) {
            this.weightAttribute = (Attribute)m.weightAttribute.clone();
        }
    }

    public static MultiClassificationPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new MultiClassificationPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public double getExampleCount() {
        double total = 0.0;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        return total;
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.labelAttribute = eSet.getAttributes().getLabel();
        if (!this.labelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", this.labelAttribute.getName());
        }
        this.predictedLabelAttribute = eSet.getAttributes().getPredictedLabel();
        if (this.predictedLabelAttribute == null || !this.predictedLabelAttribute.isNominal()) {
            throw new UserError(null, 101, "calculation of classification performance criteria", "predicted label attribute");
        }
        if (this.predictedLabelAttribute.getMapping().size() != this.labelAttribute.getMapping().size()) {
            throw new UserError(null, 118, this.predictedLabelAttribute.getName(), this.predictedLabelAttribute.getMapping().size(), " the same as the different values of the label (" + this.labelAttribute.getMapping().size() + ")");
        }
        if (useExampleWeights) {
            this.weightAttribute = eSet.getAttributes().getWeight();
        }
        List<String> values = this.labelAttribute.getMapping().getValues();
        this.counter = new double[values.size()][values.size()];
        this.classNames = new String[values.size()];
        Iterator i = values.iterator();
        int n = 0;
        while (i.hasNext()) {
            this.classNames[n] = (String)i.next();
            this.classNameMap.put(this.classNames[n], n);
            ++n;
        }
    }

    public void countExample(Example example) {
        int label = this.classNameMap.get(example.getNominalValue(this.labelAttribute));
        int plabel = this.classNameMap.get(example.getNominalValue(this.predictedLabelAttribute));
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double[] dArray = this.counter[label];
        int n = plabel;
        dArray[n] = dArray[n] + weight;
    }

    public double getMikroAverage() {
        double diagonal = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.counter.length) {
            diagonal += this.counter[i][i];
            int j = 0;
            while (j < this.counter[i].length) {
                total += this.counter[i][j];
                ++j;
            }
            ++i;
        }
        if (total == 0.0) {
            return Double.NaN;
        }
        double accuracy = diagonal / total;
        switch (this.type) {
            case 0: {
                return accuracy;
            }
            case 1: {
                return 1.0 - accuracy;
            }
            case 2: {
                double pa = accuracy;
                double pe = 0.0;
                int i2 = 0;
                while (i2 < this.counter.length) {
                    double row = 0.0;
                    double column = 0.0;
                    int j = 0;
                    while (j < this.counter[i2].length) {
                        row += this.counter[i2][j];
                        column += this.counter[j][i2];
                        ++j;
                    }
                    pe += row * column / (total * total);
                    ++i2;
                }
                return (pa - pe) / (1.0 - pe);
            }
        }
        throw new RuntimeException("Unknown type " + this.type + " for multi class performance criterion!");
    }

    public boolean formatPercent() {
        return this.type != 2;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public double getFitness() {
        if (this.type == 1) {
            return 1.0 - this.getAverage();
        }
        return this.getAverage();
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void buildSingleAverage(Averagable performance) {
        MultiClassificationPerformance other = (MultiClassificationPerformance)performance;
        int i = 0;
        while (i < this.counter.length) {
            int j = 0;
            while (j < this.counter[i].length) {
                double[] dArray = this.counter[i];
                int n = j;
                dArray[n] = dArray[n] + other.counter[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        this.viewer = new ConfusionMatrixViewer(super.toString(), this.classNames, this.counter);
        return this.viewer;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        int i = 0;
        while (i < this.counter.length) {
            result.append("\t" + this.classNames[i]);
            ++i;
        }
        i = 0;
        while (i < this.counter.length) {
            result.append(String.valueOf(Tools.getLineSeparator()) + this.classNames[i] + ":");
            int j = 0;
            while (j < this.counter[i].length) {
                result.append("\t" + Tools.formatIntegerIfPossible(this.counter[j][i]));
                ++j;
            }
            ++i;
        }
        return result.toString();
    }

    public void prepareReporting() {
        if (this.viewer == null) {
            this.getVisualizationComponent(null);
            this.viewer.prepareReporting();
        }
    }

    public void finishReporting() {
        if (this.viewer != null) {
            this.viewer.finishReporting();
            this.viewer = null;
        }
    }

    public boolean isFirstLineHeader() {
        return true;
    }

    public boolean isFirstColumnHeader() {
        return true;
    }

    public String getColumnName(int columnIndex) {
        return this.viewer.getColumnName(columnIndex);
    }

    public String getCell(int row, int column) {
        return this.viewer.getCell(row, column);
    }

    public int getColumnNumber() {
        return this.viewer.getColumnNumber();
    }

    public int getRowNumber() {
        return this.viewer.getRowNumber();
    }
}

