/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance.test;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.test.ExampleTestTools;
import com.rapidminer.operator.performance.AbsoluteError;
import com.rapidminer.operator.performance.AbstractPerformanceEvaluator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.performance.SquaredError;
import com.rapidminer.operator.performance.test.CriterionTestCase;
import com.rapidminer.tools.att.AttributeSet;
import java.util.Iterator;
import java.util.LinkedList;

public class MeasuredCriterionTest
extends CriterionTestCase {
    private ExampleSet exampleSet1;
    private ExampleSet exampleSet2;

    private ExampleSet createExampleSet(double[][] labelValues, double[] predictedValues) throws Exception {
        Attribute label = ExampleTestTools.attributeReal();
        label.setTableIndex(0);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        attributeList.add(label);
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributeList, ExampleTestTools.createDataRowReader(labelValues));
        AttributeSet attributeSet = new AttributeSet();
        attributeSet.setSpecialAttribute("label", label);
        ExampleSet exampleSet = exampleTable.createExampleSet(attributeSet);
        Attribute predictedLabel = ExampleTestTools.createPredictedLabel(exampleSet);
        Iterator r = exampleSet.iterator();
        int i = 0;
        while (i < predictedValues.length) {
            ((Example)r.next()).setValue(predictedLabel, predictedValues[i]);
            ++i;
        }
        return exampleSet;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.exampleSet1 = this.createExampleSet(new double[][]{{5.0}, {3.0}, {-1.0}, {-4.0}, {0.0}, {2.0}}, new double[]{6.0, 1.0, 0.0, -1.0, 3.0, -2.0});
        this.exampleSet2 = this.createExampleSet(new double[][]{{3.0}, {6.0}, {-1.0}}, new double[]{1.0, 8.0, -4.0});
    }

    public void tearDown() throws Exception {
        this.exampleSet2 = null;
        this.exampleSet1 = null;
        super.tearDown();
    }

    private void criterionTest(PerformanceCriterion c1, PerformanceCriterion c2, double expected1, double expected2, double expectedOverall) throws Exception {
        PerformanceVector pv1 = new PerformanceVector();
        pv1.addCriterion(c1);
        AbstractPerformanceEvaluator.evaluate(null, this.exampleSet1, pv1, new LinkedList<PerformanceCriterion>(), false, true);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c1.getName()) + " 1"), (double)expected1, (double)c1.getAverage(), (double)1.0E-8);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c1.getName()) + " 1 clone"), (double)expected1, (double)((PerformanceCriterion)c1.clone()).getAverage(), (double)1.0E-8);
        PerformanceVector pv2 = new PerformanceVector();
        pv2.addCriterion(c2);
        AbstractPerformanceEvaluator.evaluate(null, this.exampleSet2, pv2, new LinkedList<PerformanceCriterion>(), false, true);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c2.getName()) + " 2"), (double)expected2, (double)c2.getAverage(), (double)1.0E-8);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c2.getName()) + " 2 clone"), (double)expected2, (double)((PerformanceCriterion)c2.clone()).getAverage(), (double)1.0E-8);
        c1.buildAverage(c2);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c1.getName()) + " average"), (double)expectedOverall, (double)c1.getMikroAverage(), (double)1.0E-8);
        MeasuredCriterionTest.assertEquals((String)(String.valueOf(c1.getName()) + " makro average"), (double)((expected1 + expected2) / 2.0), (double)c1.getMakroAverage(), (double)1.0E-8);
    }

    public void testAbsoluteError() throws Exception {
        this.criterionTest(new AbsoluteError(), new AbsoluteError(), 2.3333333333333335, 2.3333333333333335, 2.3333333333333335);
    }

    public void testSquaredError() throws Exception {
        this.criterionTest(new SquaredError(), new SquaredError(), 6.666666666666667, 5.666666666666667, 6.333333333333333);
    }
}

