/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeSelectionExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterConditions;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSubsetPreprocessing
extends OperatorChain {
    public static final String PARAMETER_ATTRIBUTE_NAME_REGEX = "attribute_name_regex";
    public static final String PARAMETER_INVERT_SELECTION = "invert_selection";
    public static final String PARAMETER_PROCESS_SPECIAL_ATTRIBUTES = "process_special_attributes";
    public static final String PARAMETER_DELIVER_INNER_RESULTS = "deliver_inner_results";
    public static final String PARAMETER_KEEP_SUBSET_ONLY = "keep_subset_only";

    public AttributeSubsetPreprocessing(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputSet = this.getInput(ExampleSet.class);
        ExampleSet workingExampleSet = (ExampleSet)inputSet.clone();
        if (this.getParameterAsBoolean(PARAMETER_PROCESS_SPECIAL_ATTRIBUTES)) {
            workingExampleSet = new NonSpecialAttributesExampleSet(workingExampleSet);
        }
        LinkedList<Attribute> unusedAttributes = new LinkedList<Attribute>();
        workingExampleSet = this.createSubSetView(workingExampleSet, unusedAttributes);
        IOContainer input = new IOContainer(workingExampleSet);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
        ExampleSet resultSet = input.get(ExampleSet.class);
        Iterator<AttributeRole> r = resultSet.getAttributes().allAttributeRoles();
        while (r.hasNext()) {
            AttributeRole newRole = r.next();
            AttributeRole oldRole = inputSet.getAttributes().getRole(newRole.getAttribute().getName());
            if (oldRole == null || !oldRole.isSpecial()) continue;
            String specialName = oldRole.getSpecialName();
            newRole.setSpecial(specialName);
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_SUBSET_ONLY)) {
            if (resultSet.size() != inputSet.size()) {
                throw new UserError((Operator)this, 127, "changing the size of the example set is not allowed if the non-processed attributes should be kept.");
            }
            if (resultSet.getExampleTable().equals(inputSet.getExampleTable())) {
                for (Attribute attribute : unusedAttributes) {
                    AttributeRole role = inputSet.getAttributes().getRole(attribute);
                    resultSet.getAttributes().add(role);
                }
            } else {
                this.logWarning("Underlying example table has changed: data copy into new table is necessary in order to keep non-processed attributes.");
                for (Attribute oldAttribute : unusedAttributes) {
                    AttributeRole oldRole = inputSet.getAttributes().getRole(oldAttribute);
                    Attribute newAttribute = (Attribute)oldAttribute.clone();
                    resultSet.getExampleTable().addAttribute(newAttribute);
                    AttributeRole newRole = new AttributeRole(newAttribute);
                    if (oldRole.isSpecial()) {
                        newRole.setSpecial(oldRole.getSpecialName());
                    }
                    resultSet.getAttributes().add(newRole);
                    Iterator oldIterator = inputSet.iterator();
                    Iterator newIterator = resultSet.iterator();
                    while (oldIterator.hasNext()) {
                        Example oldExample = (Example)oldIterator.next();
                        Example newExample = (Example)newIterator.next();
                        newExample.setValue(newAttribute, oldExample.getValue(oldAttribute));
                    }
                }
            }
        }
        LinkedList<IOObject> allResults = new LinkedList<IOObject>();
        allResults.add(resultSet);
        if (this.getParameterAsBoolean(PARAMETER_DELIVER_INNER_RESULTS)) {
            IOObject[] iOObjectArray = input.getIOObjects();
            int n = iOObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOObject current = iOObjectArray[n2];
                if (!(current instanceof ExampleSet)) {
                    allResults.add(current);
                }
                ++n2;
            }
        }
        IOObject[] finalResult = new IOObject[allResults.size()];
        allResults.toArray(finalResult);
        return finalResult;
    }

    private ExampleSet createSubSetView(ExampleSet exampleSet, List<Attribute> unusedAttributes) throws UserError {
        Attributes attributes = exampleSet.getAttributes();
        boolean[] selectionMask = new boolean[exampleSet.getAttributes().size()];
        boolean invert = this.getParameterAsBoolean(PARAMETER_INVERT_SELECTION);
        if (3 == this.getParameterAsInt("condition_class")) {
            this.setParameter("parameter_string", this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME_REGEX));
        }
        AttributeFilterCondition condition = AttributeFilterConditions.createCondition(this);
        int a = 0;
        for (Attribute attribute : attributes) {
            if (condition != null) {
                AttributeFilterCondition.ScanResult result = condition.beforeScanCheck(attribute).invert(invert);
                switch (result) {
                    case KEEP: 
                    case UNCHECKED: {
                        selectionMask[a] = true;
                        break;
                    }
                    case REMOVE: {
                        unusedAttributes.add(attribute);
                        selectionMask[a] = false;
                    }
                }
            } else {
                selectionMask[a] = true;
            }
            if (selectionMask[a] && condition.isNeedingScan()) {
                AttributeFilterCondition.ScanResult afterScanResult = AttributeFilterCondition.ScanResult.UNCHECKED;
                for (Example example : exampleSet) {
                    AttributeFilterCondition.ScanResult result = condition.check(attribute, example);
                    if (result == AttributeFilterCondition.ScanResult.UNCHECKED) continue;
                    afterScanResult = result;
                    break;
                }
                if (condition.isNeedingFullScan()) {
                    afterScanResult = condition.checkAfterFullScan();
                } else if (afterScanResult == AttributeFilterCondition.ScanResult.UNCHECKED) {
                    afterScanResult = AttributeFilterCondition.ScanResult.KEEP;
                }
                afterScanResult = afterScanResult.invert(invert);
                if (afterScanResult == AttributeFilterCondition.ScanResult.REMOVE) {
                    selectionMask[a] = false;
                    unusedAttributes.add(attribute);
                }
            }
            ++a;
        }
        return new AttributeSelectionExampleSet(exampleSet, selectionMask);
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        Class[] innerResult = null;
        try {
            if (this.getParameterAsBoolean(PARAMETER_DELIVER_INNER_RESULTS) && this.getNumberOfOperators() > 0) {
                innerResult = this.getOperator(this.getNumberOfOperators() - 1).getOutputClasses();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (innerResult != null) {
            LinkedList<Class> completeOutput = new LinkedList<Class>();
            completeOutput.add(ExampleSet.class);
            Class[] classArray = innerResult;
            int n = innerResult.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (!clazz.equals(ExampleSet.class)) {
                    completeOutput.add(clazz);
                }
                ++n2;
            }
            Class[] result = new Class[completeOutput.size()];
            completeOutput.toArray(result);
            return result;
        }
        return new Class[]{ExampleSet.class};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{ExampleSet.class});
    }

    @Override
    public Class<?>[] checkIO(Class<?>[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.isEnabled()) {
            super.checkIO(input);
            return this.getIODescription().getOutputClasses(input, this);
        }
        return input;
    }

    @Override
    protected IODescription getIODescription() {
        return new AttributeSubsetPreprocessingIODescription(this.getOutputClasses());
    }

    @Override
    protected boolean shouldAddNonConsumedInput() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        List<ParameterType> conditionTypes = AttributeFilterConditions.getParameterTypes(this);
        for (ParameterType conditionType : conditionTypes) {
            if (!conditionType.getKey().equals("parameter_string")) continue;
            conditionType.registerDependencyCondition(new EqualTypeCondition(this, "condition_class", true, 2));
        }
        types.addAll(conditionTypes);
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME_REGEX, "A regular expression which matches against all attribute names (including special attributes).", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, "condition_class", true, 3));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_INVERT_SELECTION, "Indicates if the specified attribute selection should be inverted.", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_PROCESS_SPECIAL_ATTRIBUTES, "Indicates if special attributes like labels etc. should also be processed.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_SUBSET_ONLY, "Indicates if the attributes which did not match the regular expression should be removed by this operator.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_DELIVER_INNER_RESULTS, "Indicates if the additional results (other than example set) of the inner operator should also be returned.", false));
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeSubsetPreprocessingIODescription
    implements IODescription {
        private Class[] outputClasses;

        public AttributeSubsetPreprocessingIODescription(Class[] outputClasses) {
            this.outputClasses = outputClasses;
        }

        @Override
        public Class<?>[] getInputClasses() {
            return new Class[]{ExampleSet.class};
        }

        @Override
        public Class<?>[] getOutputClasses(Class<?>[] input, Operator operator) throws IllegalInputException {
            LinkedList<Class> outputList = new LinkedList<Class>();
            boolean found = false;
            int i = 0;
            while (i < input.length) {
                if (found || !ExampleSet.class.isAssignableFrom(input[i])) {
                    outputList.add(input[i]);
                } else {
                    found = true;
                }
                ++i;
            }
            i = 0;
            while (i < this.outputClasses.length) {
                outputList.add(this.outputClasses[i]);
                ++i;
            }
            Class[] outputArray = new Class[outputList.size()];
            outputList.toArray(outputArray);
            return outputArray;
        }
    }
}

