/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuessValueTypes
extends AbstractDataProcessing {
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_NUMBER_GROUPING_CHARACTER = "number_grouping_character";
    public static final String PARAMETER_APPLY_ON_SPECIAL = "apply_on_special";

    public GuessValueTypes(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        char decimalPointCharacter = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0);
        Character groupingCharacter = null;
        if (this.isParameterSet(PARAMETER_NUMBER_GROUPING_CHARACTER)) {
            groupingCharacter = Character.valueOf(this.getParameterAsString(PARAMETER_NUMBER_GROUPING_CHARACTER).charAt(0));
        }
        int size = 0;
        size = this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL) ? exampleSet.getAttributes().allSize() : exampleSet.getAttributes().size();
        int[] valueTypes = new int[size];
        Iterator<Attribute> a = null;
        a = this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL) ? exampleSet.getAttributes().allAttributes() : exampleSet.getAttributes().iterator();
        int index = 0;
        while (a.hasNext()) {
            Attribute attribute = a.next();
            valueTypes[index++] = attribute.getValueType();
        }
        boolean[] checked = new boolean[valueTypes.length];
        int checkedCounter = 0;
        for (Example example : exampleSet) {
            a = null;
            a = this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL) ? exampleSet.getAttributes().allAttributes() : exampleSet.getAttributes().iterator();
            index = 0;
            while (a.hasNext()) {
                Attribute attribute = a.next();
                double originalValue = example.getValue(attribute);
                if (!Double.isNaN(originalValue) && !checked[index]) {
                    try {
                        String valueString = example.getValueAsString(attribute);
                        if (!"?".equals(valueString)) {
                            double value;
                            if (groupingCharacter != null) {
                                valueString = valueString.replace(groupingCharacter.toString(), "");
                            }
                            valueTypes[index] = Tools.isEqual(Math.round(value = Double.parseDouble(valueString = valueString.replace(decimalPointCharacter, '.'))), value) ? 3 : 4;
                        }
                    }
                    catch (NumberFormatException e) {
                        valueTypes[index] = 1;
                        checked[index] = true;
                        ++checkedCounter;
                    }
                }
                ++index;
            }
            if (checkedCounter >= checked.length) break;
        }
        LinkedList<AttributeRole> newAttributes = new LinkedList<AttributeRole>();
        Iterator<AttributeRole> r = null;
        r = this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL) ? exampleSet.getAttributes().allAttributeRoles() : exampleSet.getAttributes().regularAttributes();
        index = 0;
        while (r.hasNext()) {
            AttributeRole role = r.next();
            Attribute attribute = role.getAttribute();
            Attribute newAttribute = AttributeFactory.createAttribute(valueTypes[index]);
            exampleSet.getExampleTable().addAttribute(newAttribute);
            AttributeRole newRole = new AttributeRole(newAttribute);
            newRole.setSpecial(role.getSpecialName());
            newAttributes.add(newRole);
            for (Example e : exampleSet) {
                double oldValue = e.getValue(attribute);
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueTypes[index], 2)) {
                    if (!Double.isNaN(oldValue)) {
                        String valueString = e.getValueAsString(attribute);
                        if ("?".equals(valueString)) {
                            e.setValue(newAttribute, Double.NaN);
                            continue;
                        }
                        if (groupingCharacter != null) {
                            valueString = valueString.replace(groupingCharacter.toString(), "");
                        }
                        valueString = valueString.replace(decimalPointCharacter, '.');
                        e.setValue(newAttribute, Double.parseDouble(valueString));
                        continue;
                    }
                    e.setValue(newAttribute, Double.NaN);
                    continue;
                }
                if (!Double.isNaN(oldValue)) {
                    String value = e.getValueAsString(attribute);
                    e.setValue(newAttribute, newAttribute.getMapping().mapString(value));
                    continue;
                }
                e.setValue(newAttribute, Double.NaN);
            }
            exampleSet.getExampleTable().removeAttribute(attribute);
            r.remove();
            newAttribute.setName(attribute.getName());
            ++index;
        }
        for (AttributeRole role : newAttributes) {
            if (role.isSpecial()) {
                exampleSet.getAttributes().setSpecialAttribute(role.getAttribute(), role.getSpecialName());
                continue;
            }
            exampleSet.getAttributes().addRegular(role.getAttribute());
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeString(PARAMETER_NUMBER_GROUPING_CHARACTER, "Character that is used as the number grouping character, i.e. for groups of thousands.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_SPECIAL, "Indicates if this operator should also be applied on the special attributes.", false));
        return types;
    }
}

