/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseRowAsAttributeNames
extends AbstractDataProcessing {
    public static final String PARAMETER_ROW_NUMBER = "row_number";

    public UseRowAsAttributeNames(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int rowNumber = this.getParameterAsInt(PARAMETER_ROW_NUMBER) - 1;
        if (rowNumber < 0 || rowNumber > exampleSet.size() - 1) {
            throw new UserError((Operator)this, 207, rowNumber + 1, PARAMETER_ROW_NUMBER, "the value must be between 1 and the number of available examples");
        }
        Example example = exampleSet.getExample(rowNumber);
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            double value = example.getValue(attribute);
            String newName = String.valueOf(value);
            if (attribute.isNominal()) {
                newName = attribute.getMapping().mapIndex((int)value);
            }
            attribute.setName(newName);
        }
        int[] elements = new int[exampleSet.size()];
        elements[0] = 0;
        int i = 1;
        while (i < elements.length) {
            elements[i] = 1;
            ++i;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(elements, 2));
        result.selectSingleSubset(1);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ROW_NUMBER, "Indicates which row should be used as attribute names. Counting starts with 1.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

