/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserBasedDiscretization
extends PreprocessingOperator {
    public static final String PARAMETER_ATTRIBUTE_TYPE = "attribute_type";
    public static final String PARAMETER_UPPER_LIMIT = "upper_limit";
    public static final String PARAMETER_RANGE_NAMES = "classes";
    public static final String[] attributeTypeStrings = new String[]{"nominal", "ordinal"};
    public static final int ATTRIBUTE_TYPE_NOMINAL = 0;
    public static final int ATTRIBUTE_TYPE_ORDINAL = 1;

    public UserBasedDiscretization(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        HashMap<String, SortedSet<Tupel<Double, String>>> ranges = new HashMap<String, SortedSet<Tupel<Double, String>>>();
        List<String[]> rangeList = this.getParameterList(PARAMETER_RANGE_NAMES);
        TreeSet<Tupel<Double, String>> thresholdPairs = new TreeSet<Tupel<Double, String>>();
        for (String[] pair : rangeList) {
            thresholdPairs.add(new Tupel<Double, String>(Double.valueOf(pair[1]), pair[0]));
        }
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            ranges.put(attribute.getName(), thresholdPairs);
        }
        DiscretizationModel model = new DiscretizationModel(exampleSet);
        model.setRanges(ranges);
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeCategory(PARAMETER_ATTRIBUTE_TYPE, "Attribute type of the discretized attribute.", attributeTypeStrings, 0);
        type.setExpert(false);
        types.add(type);
        ParameterTypeDouble threshold = new ParameterTypeDouble(PARAMETER_UPPER_LIMIT, "The upper limit.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        LinkedList<Object[]> defaultList = new LinkedList<Object[]>();
        Object[] defaultListEntry = new Object[]{"last", Double.POSITIVE_INFINITY};
        defaultList.add(defaultListEntry);
        type = new ParameterTypeList(PARAMETER_RANGE_NAMES, "Defines the classes and the upper limits of each class.", threshold, defaultList);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

