/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueMapper
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";
    public static final String PARAMETER_VALUE_MAPPINGS = "value_mappings";
    public static final String PARAMETER_OLD_VALUES = "old_values";
    public static final String PARAMETER_REPLACE_WHAT = "replace_what";
    public static final String PARAMETER_REPLACE_BY = "replace_by";
    public static final String PARAMETER_CONSIDER_REGULAR_EXPRESSIONS = "consider_regular_expressions";
    public static final String PARAMETER_ADD_DEFAULT_MAPPING = "add_default_mapping";
    public static final String PARAMETER_DEFAULT_VALUE = "default_value";

    public AttributeValueMapper(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        block42: {
            String attributeNameRegex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(attributeNameRegex);
            }
            catch (PatternSyntaxException e) {
                throw new UserError((Operator)this, 206, attributeNameRegex, e.getMessage());
            }
            boolean nominal = false;
            boolean first = true;
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iterator = this.getParameterAsBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES) ? exampleSet.getAttributes().allAttributes() : exampleSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                Matcher matcher = pattern.matcher(attribute.getName());
                if (matcher.matches()) {
                    if (first) {
                        nominal = attribute.isNominal();
                        first = false;
                    } else if (nominal != attribute.isNominal()) {
                        throw new UserError(this, 126);
                    }
                    attributes.add(attribute);
                }
                this.checkForStop();
            }
            boolean useValueRegex = this.getParameterAsBoolean(PARAMETER_CONSIDER_REGULAR_EXPRESSIONS);
            List<String[]> mappingParameterList = this.getParameterList(PARAMETER_VALUE_MAPPINGS);
            HashMap<String, String> mappings = new HashMap<String, String>();
            HashMap<Pattern, String> patternMappings = new HashMap<Pattern, String>();
            String replaceWhat = this.getParameterAsString(PARAMETER_REPLACE_WHAT);
            String replaceBy = this.getParameterAsString(PARAMETER_REPLACE_BY);
            if (replaceWhat != null && replaceBy != null && !replaceWhat.equals("") && !replaceBy.equals("")) {
                mappings.put(replaceWhat, replaceBy);
                if (useValueRegex) {
                    try {
                        Pattern valuePattern = Pattern.compile(replaceWhat);
                        patternMappings.put(valuePattern, replaceBy);
                    }
                    catch (PatternSyntaxException e) {
                        throw new UserError((Operator)this, 206, replaceWhat, e.getMessage());
                    }
                }
            }
            Iterator<String[]> listIterator = mappingParameterList.iterator();
            int j = 0;
            while (listIterator.hasNext()) {
                String[] pair = listIterator.next();
                replaceWhat = pair[1];
                replaceBy = pair[0];
                mappings.put(replaceWhat, replaceBy);
                if (useValueRegex) {
                    try {
                        Pattern valuePattern = Pattern.compile(replaceWhat);
                        patternMappings.put(valuePattern, replaceBy);
                    }
                    catch (PatternSyntaxException e) {
                        throw new UserError((Operator)this, 206, replaceWhat, e.getMessage());
                    }
                }
                ++j;
            }
            boolean defaultMappingAdded = this.getParameterAsBoolean(PARAMETER_ADD_DEFAULT_MAPPING);
            String defaultValue = this.getParameterAsString(PARAMETER_DEFAULT_VALUE);
            if (defaultMappingAdded && (defaultValue == null || defaultValue.equals(""))) {
                throw new UserError((Operator)this, 201, PARAMETER_ADD_DEFAULT_MAPPING, "true", PARAMETER_DEFAULT_VALUE);
            }
            if (attributes.size() <= 0) break block42;
            if (nominal) {
                for (Attribute attribute : attributes) {
                    Attribute newAttribute = AttributeFactory.createAttribute("mapped" + attribute.getName(), attribute.getValueType());
                    exampleSet.getExampleTable().addAttribute(newAttribute);
                    exampleSet.getAttributes().addRegular(newAttribute);
                    for (Example example : exampleSet) {
                        double value = example.getValue(attribute);
                        String stringValue = null;
                        stringValue = Double.isNaN(value) ? "?" : attribute.getMapping().mapIndex((int)value);
                        String mappedValue = (String)mappings.get(stringValue);
                        if (useValueRegex) {
                            for (Map.Entry entry : patternMappings.entrySet()) {
                                Matcher matcher = ((Pattern)entry.getKey()).matcher(stringValue);
                                if (!matcher.matches()) continue;
                                mappedValue = (String)entry.getValue();
                            }
                        }
                        if (mappedValue == null) {
                            if (stringValue.equals("?")) {
                                example.setValue(newAttribute, Double.NaN);
                            } else if (defaultMappingAdded) {
                                if (defaultValue.equals("?")) {
                                    example.setValue(newAttribute, Double.NaN);
                                } else {
                                    example.setValue(newAttribute, defaultValue);
                                }
                            } else {
                                example.setValue(newAttribute, newAttribute.getMapping().mapString(stringValue));
                            }
                        } else if (mappedValue.equals("?")) {
                            example.setValue(newAttribute, Double.NaN);
                        } else {
                            example.setValue(newAttribute, newAttribute.getMapping().mapString(mappedValue));
                        }
                        this.checkForStop();
                    }
                    AttributeRole role = exampleSet.getAttributes().getRole(attribute);
                    exampleSet.getAttributes().remove(attribute);
                    newAttribute.setName(attribute.getName());
                    if (!role.isSpecial()) continue;
                    exampleSet.getAttributes().setSpecialAttribute(newAttribute, role.getSpecialName());
                }
            } else {
                HashMap<Double, Double> numericalValueMapping = new HashMap<Double, Double>();
                for (Map.Entry entry : mappings.entrySet()) {
                    double oldValue = Double.NaN;
                    double newValue = Double.NaN;
                    if (!((String)entry.getKey()).equals("?")) {
                        oldValue = Double.valueOf((String)entry.getKey());
                    }
                    if (!((String)entry.getValue()).equals("?")) {
                        newValue = Double.valueOf((String)entry.getValue());
                    }
                    numericalValueMapping.put(oldValue, newValue);
                }
                double numericalDefaultValue = Double.NaN;
                if (defaultMappingAdded && !defaultValue.equals("?")) {
                    numericalDefaultValue = Double.valueOf(defaultValue);
                }
                for (Attribute attribute : attributes) {
                    Attribute newAttribute = AttributeFactory.createAttribute("mapped" + attribute.getName(), attribute.getValueType());
                    exampleSet.getExampleTable().addAttribute(newAttribute);
                    exampleSet.getAttributes().addRegular(newAttribute);
                    for (Example example : exampleSet) {
                        double value = example.getValue(attribute);
                        Double mappedValue = (Double)numericalValueMapping.get(value);
                        if (mappedValue == null) {
                            if (defaultMappingAdded) {
                                example.setValue(newAttribute, numericalDefaultValue);
                            } else {
                                example.setValue(newAttribute, value);
                            }
                        } else {
                            example.setValue(newAttribute, mappedValue);
                        }
                        this.checkForStop();
                    }
                    AttributeRole role = exampleSet.getAttributes().getRole(attribute);
                    exampleSet.getAttributes().remove(attribute);
                    newAttribute.setName(attribute.getName());
                    if (!role.isSpecial()) continue;
                    exampleSet.getAttributes().setSpecialAttribute(newAttribute, role.getSpecialName());
                }
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "The specified values will be merged in all attributes specified by the given regular expression.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        ParameterTypeString values = new ParameterTypeString(PARAMETER_OLD_VALUES, "The original values which should be replaced.", false);
        types.add(new ParameterTypeList(PARAMETER_VALUE_MAPPINGS, "The value mappings.", values));
        types.add(new ParameterTypeString(PARAMETER_REPLACE_WHAT, "All occurrences of this value will be replaced.", true));
        types.add(new ParameterTypeString(PARAMETER_REPLACE_BY, "The new attribute value to use.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_CONSIDER_REGULAR_EXPRESSIONS, "Enables matching based on regular expressions; original values may be specified as regular expressions.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_ADD_DEFAULT_MAPPING, "If set to true, all original values which are not listed in the value mappings list are mapped to the default value.", false));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_DEFAULT_VALUE, "The default value all original values are mapped to, if add_default_mapping is set to true.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_ADD_DEFAULT_MAPPING, true, true));
        types.add(type);
        return types;
    }
}

