/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAttributeType
extends AbstractDataProcessing {
    public static final String PARAMETER_NAME = "name";
    public static final String PARAMETER_TARGET_TYPE = "target_type";
    private static final String REGULAR_NAME = "regular";
    private static final String[] TARGET_TYPES = new String[]{"regular", "id", "label", "prediction", "cluster", "weight", "batch"};

    public ChangeAttributeType(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String name = this.getParameterAsString(PARAMETER_NAME);
        Attribute attribute = exampleSet.getAttributes().get(name);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, name);
        }
        exampleSet.getAttributes().remove(attribute);
        String newType = this.getParameterAsString(PARAMETER_TARGET_TYPE);
        if (newType == null || newType.trim().length() == 0) {
            throw new UserError((Operator)this, 201, PARAMETER_TARGET_TYPE, "change_attribute_type", "true");
        }
        if (newType.equals(REGULAR_NAME)) {
            exampleSet.getAttributes().addRegular(attribute);
        } else {
            exampleSet.getAttributes().setSpecialAttribute(attribute, newType);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NAME, "The name of the attribute of which the type should be changed.", false));
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_TARGET_TYPE, "The target type of the attribute (only changed if parameter change_attribute_type is true).", TARGET_TYPES, TARGET_TYPES[0]);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

