/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.preprocessing.filter.ValueReplenishment;

public class InfiniteValueReplenishment
extends ValueReplenishment {
    private static final int NONE = 0;
    private static final int ZERO = 1;
    private static final int MAX_BYTE = 2;
    private static final int MAX_INT = 3;
    private static final int MAX_DOUBLE = 4;
    private static final int MISSING = 5;
    private static final int VALUE = 6;
    private static final String[] REP_NAMES = new String[]{"none", "zero", "max_byte", "max_int", "max_double", "missing", "value"};

    public InfiniteValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public boolean replenishValue(double currentValue) {
        return Double.isInfinite(currentValue);
    }

    public String[] getFunctionNames() {
        return REP_NAMES;
    }

    public int getDefaultFunction() {
        return 4;
    }

    public int getDefaultColumnFunction() {
        return 1;
    }

    public double getReplenishmentValue(int functionIndex, ExampleSet exampleSet, Attribute attribute, double currentValue, String valueString) {
        switch (functionIndex) {
            case 0: {
                return currentValue;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return currentValue > 0.0 ? 127 : -128;
            }
            case 3: {
                return currentValue > 0.0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
            case 4: {
                return currentValue > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
            case 5: {
                return Double.NaN;
            }
            case 6: {
                return Double.parseDouble(valueString);
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }
}

