/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.AnovaCalculator;
import com.rapidminer.tools.math.SignificanceCalculationException;
import com.rapidminer.tools.math.SignificanceTestResult;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import com.rapidminer.tools.math.function.aggregation.VarianceFunction;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedANOVAOperator
extends Operator {
    public static final String PARAMETER_ANOVA_ATTRIBUTE = "anova_attribute";
    public static final String PARAMETER_GROUP_BY_ATTRIBUTE = "group_by_attribute";
    public static final String PARAMETER_SIGNIFICANCE_LEVEL = "significance_level";
    public static final String PARAMETER_ONLY_DISTINCT = "only_distinct";

    public GroupedANOVAOperator(OperatorDescription desc) {
        super(desc);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        String attributeName = this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE);
        String groupByAttributeName = this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE);
        boolean onlyDistinct = this.getParameterAsBoolean(PARAMETER_ONLY_DISTINCT);
        Attribute anovaAttribute = exampleSet.getAttributes().get(attributeName);
        if (anovaAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE));
        }
        if (anovaAttribute.isNominal()) {
            throw new UserError((Operator)this, 104, this.getParameterAsString(PARAMETER_ANOVA_ATTRIBUTE), "anova calculation");
        }
        Attribute groupByAttribute = exampleSet.getAttributes().get(groupByAttributeName);
        if (groupByAttribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE));
        }
        if (!groupByAttribute.isNominal()) {
            throw new UserError((Operator)this, 103, this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTE), "grouping by attribute.");
        }
        AnovaCalculator anovaCalculator = new AnovaCalculator();
        double alpha = this.getParameterAsDouble(PARAMETER_SIGNIFICANCE_LEVEL);
        anovaCalculator.setAlpha(alpha);
        SplittedExampleSet grouped = SplittedExampleSet.splitByAttribute(exampleSet, groupByAttribute);
        AverageFunction meanFunction = new AverageFunction();
        VarianceFunction varianceFunction = new VarianceFunction();
        int i = 0;
        while (i < grouped.getNumberOfSubsets()) {
            grouped.selectSingleSubset(i);
            double[] values = this.getValues(grouped, anovaAttribute, onlyDistinct);
            double mean = meanFunction.calculate(values);
            double variance = varianceFunction.calculate(values);
            anovaCalculator.addGroup(grouped.size(), mean, variance);
            ++i;
        }
        SignificanceTestResult result = null;
        try {
            result = anovaCalculator.performSignificanceTest();
        }
        catch (SignificanceCalculationException e) {
            throw new UserError((Operator)this, 920, e.getMessage());
        }
        return new IOObject[]{result};
    }

    private double[] getValues(ExampleSet exampleSet, Attribute attribute, boolean onlyDistinct) {
        AbstractCollection valueCollection = new LinkedList();
        if (onlyDistinct) {
            valueCollection = new TreeSet();
        }
        for (Example e : exampleSet) {
            valueCollection.add(e.getValue(attribute));
        }
        double[] result = new double[valueCollection.size()];
        int counter = 0;
        Iterator iterator = valueCollection.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            result[counter++] = d;
        }
        return result;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{SignificanceTestResult.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ANOVA_ATTRIBUTE, "Calculate the ANOVA for this attribute based on the groups defines by group_by_attribute.", false));
        types.add(new ParameterTypeString(PARAMETER_GROUP_BY_ATTRIBUTE, "Performs a grouping by the values of the attribute with this name.", false));
        types.add(new ParameterTypeDouble(PARAMETER_SIGNIFICANCE_LEVEL, "The significance level for the ANOVA calculation.", 0.0, 1.0, 0.05));
        types.add(new ParameterTypeBoolean(PARAMETER_ONLY_DISTINCT, "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        return types;
    }
}

