/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.AbstractExampleSetEvaluator;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.WekaTools;
import java.util.BitSet;
import weka.attributeSelection.CfsSubsetEval;
import weka.core.Instances;

public class CFSFeatureSetEvaluator
extends AbstractExampleSetEvaluator {
    public CFSFeatureSetEvaluator(OperatorDescription description) {
        super(description);
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public PerformanceVector evaluate(ExampleSet exampleSet) throws OperatorException {
        Instances instances = WekaTools.toWekaInstances(exampleSet, "TempInstances", 0);
        double performance = 0.0;
        try {
            CfsSubsetEval evaluator = new CfsSubsetEval();
            evaluator.buildEvaluator(instances);
            BitSet bitSet = new BitSet(exampleSet.getAttributes().size());
            bitSet.flip(0, exampleSet.getAttributes().size());
            performance = evaluator.evaluateSubset(bitSet);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, "CfsSubsetEval", e.getMessage());
        }
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("CorrelationFS", performance, 1, false));
        return result;
    }
}

