/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.value;

import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.value.ParameterValues;

public class ParameterValueGrid
extends ParameterValues {
    public static final int SCALE_LINEAR = 0;
    public static final int SCALE_QUADRATIC = 1;
    public static final int SCALE_LOGARITHMIC = 2;
    public static final String[] SCALES = new String[]{"linear", "quadratic", "logarithmic"};
    public static final int DEFAULT_STEPS = 10;
    public static final int DEFAULT_SCALE = 0;
    private double min;
    private double max;
    private int steps;
    private int scale;

    public ParameterValueGrid(Operator operator, ParameterType type, double min, double max) {
        this(operator, type, min, max, 10, 0);
    }

    public ParameterValueGrid(Operator operator, ParameterType type, double min, double max, double stepSize) {
        this(operator, type, min, max, (int)((max - min) / stepSize), 0);
    }

    public ParameterValueGrid(Operator operator, ParameterType type, double min, double max, int steps, int scale) {
        super(operator, type);
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.scale = scale;
    }

    public ParameterValueGrid(Operator operator, ParameterType type, double min, double max, int steps, String scaleName) {
        super(operator, type);
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.scale = 0;
        int i = 0;
        while (i < SCALES.length) {
            if (scaleName.equals(SCALES[i])) {
                this.scale = i;
                break;
            }
            ++i;
        }
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void move(int index, int direction) {
    }

    public String[] getValuesArray() {
        double[] values = this.getValues();
        String[] valuesArray = new String[values.length];
        if (this.type instanceof ParameterTypeInt) {
            int i = 0;
            while (i < values.length) {
                valuesArray[i] = Integer.toString((int)values[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < values.length) {
                valuesArray[i] = Double.toString(values[i]);
                ++i;
            }
        }
        return valuesArray;
    }

    public double[] getValues() {
        double[] values = null;
        switch (this.scale) {
            case 0: {
                values = this.scalePolinomial(this.steps, 1.0);
                break;
            }
            case 1: {
                values = this.scalePolinomial(this.steps, 2.0);
                break;
            }
            case 2: {
                values = this.scaleLogarithmic(this.steps);
                break;
            }
            default: {
                values = this.scalePolinomial(this.steps, 1.0);
            }
        }
        if (this.type instanceof ParameterTypeInt) {
            if (values.length > 0) {
                int i = 0;
                while (i < values.length) {
                    values[i] = Math.round(values[i]);
                    ++i;
                }
                int count = 1;
                int i2 = 1;
                while (i2 < values.length) {
                    if (values[i2] != values[i2 - 1]) {
                        ++count;
                    }
                    ++i2;
                }
                double[] uniqueValues = new double[count];
                uniqueValues[0] = values[0];
                count = 1;
                int i3 = 1;
                while (i3 < values.length) {
                    if (values[i3] != values[i3 - 1]) {
                        uniqueValues[count] = values[i3];
                        ++count;
                    }
                    ++i3;
                }
                return uniqueValues;
            }
            return values;
        }
        return values;
    }

    private double[] scalePolinomial(int steps, double power) {
        double[] values = new double[steps + 1];
        int i = 0;
        while (i < steps + 1) {
            values[i] = this.min + Math.pow((double)i / (double)steps, power) * (this.max - this.min);
            ++i;
        }
        return values;
    }

    private double[] scaleLogarithmic(int steps) {
        double[] values = new double[steps + 1];
        double offset = 1.0 - this.min;
        int i = 0;
        while (i < steps + 1) {
            values[i] = Math.pow(this.max + offset, (double)i / (double)steps) - offset;
            ++i;
        }
        return values;
    }

    public int getNumberOfValues() {
        return this.steps + 1;
    }

    public String getValuesString() {
        return "[" + Double.toString(this.min) + ";" + Double.toString(this.max) + ";" + Integer.toString(this.steps) + ";" + SCALES[this.scale] + "]";
    }

    public String toString() {
        return "grid: " + this.min + " - " + this.max + " (" + this.steps + ", " + SCALES[this.scale] + ")";
    }
}

