/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.test;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.test.OperatorDataSampleTest;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.io.File;

public class IOConsumingDataSampleTest
extends OperatorDataSampleTest {
    private static final int DELETE_ONE = 0;
    private static final int DELETE_ALL = 1;
    private int copies = 0;
    private Operator op = null;
    private Process process = null;
    private IOObject obj = null;

    public IOConsumingDataSampleTest(String file, int copies) {
        super(file);
        this.copies = copies;
    }

    public void checkOutput(IOContainer output) throws MissingIOObjectException {
        try {
            if (this.process.getOperator("IOConsumer") == null) {
                this.obj = output.getElementAt(0);
                int i = this.copies;
                while (i >= 0) {
                    IOConsumingDataSampleTest.assertEquals(this.obj.getClass(), output.getElementAt(i).getClass());
                    output.remove(this.obj.getClass(), i);
                    --i;
                }
                IOConsumingDataSampleTest.assertEquals((int)0, (int)output.size());
            } else {
                this.op = this.process.getOperator("IOConsumer");
                switch (this.op.getParameterAsInt("deletion_type")) {
                    case 0: {
                        IOConsumingDataSampleTest.assertEquals((int)this.copies, (int)output.size());
                        break;
                    }
                    case 1: {
                        IOConsumingDataSampleTest.assertEquals((int)0, (int)output.size());
                    }
                }
            }
        }
        catch (UndefinedParameterError e) {
            e.printStackTrace();
        }
    }

    public void sampleTest() throws Exception {
        File processFile = new File(ParameterService.getRapidMinerHome(), "test" + File.separator + this.file);
        if (!processFile.exists()) {
            throw new Exception("File '" + processFile.getAbsolutePath() + "' does not exist!");
        }
        LogService.getGlobal().setVerbosityLevel(9);
        this.process = RapidMiner.readProcessFile(processFile);
        this.op = this.process.getOperator("IOMultiplier");
        if (this.copies > 1) {
            this.op.setParameter("number_of_copies", Integer.toString(this.copies));
        }
        IOContainer output = this.process.run(new IOContainer(), 9);
        this.checkOutput(output);
    }
}

