/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailSender;
import java.util.Date;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class MailSenderSMTP
implements MailSender {
    public void sendEmail(String address, String subject, String content) throws Exception {
        String host = System.getProperty("rapidminer.tools.smtp.host");
        if (host == null) {
            LogService.getGlobal().log("Must specify SMTP host to use SMTP.", 6);
        } else {
            String port;
            Properties props = new Properties();
            props.put("mail.smtp.host", host);
            props.put("mail.from", "no-reply@rapidminer.com");
            final String user = System.getProperty("rapidminer.tools.smtp.user");
            props.put("mail.user", user);
            final String passwd = System.getProperty("rapidminer.tools.smtp.passwd");
            Authenticator authenticator = null;
            if (passwd != null && passwd.length() > 0) {
                props.setProperty("mail.smtp.submitter", user);
                props.setProperty("mail.smtp.auth", "true");
                authenticator = new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(user, passwd);
                    }
                };
            }
            if ((port = System.getProperty("rapidminer.tools.smtp.port")) != null) {
                props.setProperty("mail.smtp.port", port);
            }
            Session session = Session.getInstance((Properties)props, authenticator);
            MimeMessage msg = new MimeMessage(session);
            msg.setRecipients(Message.RecipientType.TO, address);
            msg.setFrom();
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setText(content);
            Transport.send((Message)msg);
        }
    }
}

