/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.NominalStatistics;
import com.rapidminer.example.NumericalStatistics;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.WeightedNumericalStatistics;
import com.rapidminer.example.table.BinominalAttribute;
import com.rapidminer.example.table.BinominalMapping;
import com.rapidminer.example.table.NumericalAttribute;
import com.rapidminer.example.table.PolynominalAttribute;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.tools.LogService;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;

public class XMLSerialization {
    private static XMLSerialization singleton;
    private XStream xStream;

    public XMLSerialization(ClassLoader classLoader) {
        try {
            Class<?> xStreamClass = Class.forName("com.thoughtworks.xstream.XStream");
            Class<?> generalDriverClass = Class.forName("com.thoughtworks.xstream.io.HierarchicalStreamDriver");
            Constructor<?> constructor = xStreamClass.getConstructor(generalDriverClass);
            Class<?> driverClass = Class.forName("com.thoughtworks.xstream.io.xml.XppDriver");
            this.xStream = (XStream)constructor.newInstance(driverClass.newInstance());
            this.xStream.setMode(1002);
            this.addAlias("IOContainer", IOContainer.class);
            this.addAlias("PolynominalAttribute", PolynominalAttribute.class);
            this.addAlias("BinominalAttribute", BinominalAttribute.class);
            this.addAlias("NumericalAttribute", NumericalAttribute.class);
            this.addAlias("PolynominalMapping", PolynominalMapping.class);
            this.addAlias("BinominalMapping", BinominalMapping.class);
            this.addAlias("NumericalStatistics", NumericalStatistics.class);
            this.addAlias("WeightedNumericalStatistics", WeightedNumericalStatistics.class);
            this.addAlias("NominalStatistics", NominalStatistics.class);
            this.addAlias("UnknownStatistics", UnknownStatistics.class);
            this.addAlias("SimpleAttributes", SimpleAttributes.class);
            this.addAlias("AttributeRole", AttributeRole.class);
            this.xStream.setClassLoader(classLoader);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot initialize XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided. XML serialization will not work!", 6);
        }
    }

    public static void init(ClassLoader classLoader) {
        singleton = new XMLSerialization(classLoader);
    }

    public void addAlias(String name, Class clazz) {
        if (this.xStream != null) {
            this.xStream.alias(name, clazz);
        }
    }

    public void writeXML(Object object, OutputStream out) throws IOException {
        if (this.xStream == null) {
            LogService.getGlobal().log("Cannot write XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided...", 6);
            throw new IOException("Cannot write object with XML serialization.");
        }
        ObjectOutputStream xOut = this.xStream.createObjectOutputStream((Writer)new OutputStreamWriter(out));
        xOut.writeObject(object);
        xOut.close();
    }

    public Object fromXML(InputStream in) throws IOException {
        if (this.xStream != null) {
            try {
                ObjectInputStream xIn = this.xStream.createObjectInputStream((Reader)new InputStreamReader(in));
                Object result = null;
                try {
                    result = xIn.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Class not found: " + e.getMessage());
                }
                return result;
            }
            catch (Throwable e) {
                throw new IOException("Cannot read from XML stream, wrong format: " + e.getMessage());
            }
        }
        LogService.getGlobal().log("Cannot read object from XML serialization. Probably the libraries 'xstream.jar' and 'xpp.jar' were not provided...", 6);
        throw new IOException("Cannot read object from XML serialization.");
    }

    public static XMLSerialization getXMLSerialization() {
        return singleton;
    }
}

