/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.att;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.att.AttributeDataSources;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttributeDataSource {
    private File file;
    private int column;
    private Attribute attribute;
    private String attributeType;

    public AttributeDataSource(Attribute attribute, File file, int column, String attributeType) {
        this.attribute = attribute;
        this.file = file;
        this.column = column;
        this.attributeType = attributeType;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public void setType(String type) {
        this.attributeType = type;
    }

    public String getType() {
        return this.attributeType;
    }

    public void setSource(File file, int column) {
        this.file = file;
        this.column = column;
    }

    public void writeXML(PrintWriter out, File defaultSource) throws IOException {
        out.println("  <" + Tools.escapeXML(this.attributeType));
        out.println("    name       = \"" + Tools.escapeXML(this.attribute.getName()) + "\"");
        if (!this.getFile().equals(defaultSource)) {
            out.println("    sourcefile = \"" + this.getFile().getAbsolutePath() + "\"");
        }
        out.println("    sourcecol  = \"" + (this.getColumn() + 1) + "\"");
        out.print("    valuetype  = \"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.attribute.getValueType()) + "\"");
        if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.attribute.getBlockType(), 1)) {
            out.print(String.valueOf(Tools.getLineSeparator()) + "    blocktype  = \"" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.attribute.getBlockType()) + "\"");
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.attribute.getValueType(), 1) && !this.attributeType.equals(Attributes.KNOWN_ATTRIBUTE_TYPES[2])) {
            out.println(">");
            Iterator<String> i = this.attribute.getMapping().getValues().iterator();
            while (i.hasNext()) {
                out.println("    <value>" + Tools.escapeXML(i.next()) + "</value>");
            }
            out.println("  </" + Tools.escapeXML(this.attributeType) + ">" + Tools.getLineSeparator());
        } else {
            out.println("/>" + Tools.getLineSeparator());
        }
    }

    public static AttributeDataSources createAttributeDataSources(File attributeDescriptionFile, boolean sourceColRequired, LoggingHandler logging) throws XMLException, ParserConfigurationException, SAXException, IOException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(attributeDescriptionFile);
        Element attributeSet = document.getDocumentElement();
        if (!attributeSet.getTagName().equals("attributeset")) {
            throw new XMLException("Outer tag of attribute description file must be <attributeset>");
        }
        File defaultSource = null;
        if (attributeSet.getAttribute("default_source") != null) {
            defaultSource = Tools.getFile(attributeDescriptionFile.getParentFile(), attributeSet.getAttribute("default_source"));
        }
        LinkedList<AttributeDataSource> attributeDataSources = new LinkedList<AttributeDataSource>();
        NodeList attributes = attributeSet.getChildNodes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            if (node instanceof Element) {
                int blockType;
                int valueType;
                int lastSourceCol;
                int firstSourceCol;
                String file;
                String name;
                String type;
                Element attributeTag;
                block42: {
                    block41: {
                        attributeTag = (Element)node;
                        type = attributeTag.getTagName();
                        name = attributeTag.getAttribute("name");
                        file = null;
                        Attr fileAttr = attributeTag.getAttributeNode("sourcefile");
                        if (fileAttr != null) {
                            file = fileAttr.getValue();
                        }
                        firstSourceCol = -1;
                        Attr sourcecolAttr = attributeTag.getAttributeNode("sourcecol");
                        if (sourcecolAttr != null) {
                            if (sourcecolAttr.getValue().equals("none")) {
                                firstSourceCol = -1;
                            } else {
                                try {
                                    firstSourceCol = Integer.parseInt(sourcecolAttr.getValue()) - 1;
                                }
                                catch (NumberFormatException e) {
                                    throw new XMLException("Attribute sourcecol must be 'none' or an integer (was: '" + sourcecolAttr.getValue() + "')!");
                                }
                            }
                        }
                        lastSourceCol = -1;
                        Attr sourceEndAttr = attributeTag.getAttributeNode("sourcecol_end");
                        if (sourceEndAttr != null) {
                            try {
                                lastSourceCol = Integer.parseInt(sourceEndAttr.getValue()) - 1;
                            }
                            catch (NumberFormatException e) {
                                throw new XMLException("Attribute sourcecol_end must be 'none' or an integer (was: '" + sourceEndAttr.getValue() + "')!");
                            }
                        }
                        valueType = 0;
                        Attr valueTypeAttr = attributeTag.getAttributeNode("valuetype");
                        if (valueTypeAttr != null) {
                            try {
                                valueType = Integer.parseInt(valueTypeAttr.getValue());
                            }
                            catch (NumberFormatException e) {
                                valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(valueTypeAttr.getValue());
                                if (valueType >= 0) break block41;
                                throw new XMLException("valuetype must be an index number or a legal value type name (was: '" + valueTypeAttr.getValue() + "')");
                            }
                        }
                    }
                    blockType = 1;
                    Attr blockTypeAttr = attributeTag.getAttributeNode("blocktype");
                    if (blockTypeAttr != null) {
                        try {
                            blockType = Integer.parseInt(blockTypeAttr.getValue());
                        }
                        catch (NumberFormatException e) {
                            blockType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(blockTypeAttr.getValue());
                            if (blockType >= 0) break block42;
                            throw new XMLException("blocktype must be an index number or a legal block type name (was: '" + blockTypeAttr.getValue() + "')");
                        }
                    }
                }
                LinkedList<String> classList = null;
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
                    classList = new LinkedList<String>();
                    NodeList values = attributeTag.getElementsByTagName("value");
                    int v = 0;
                    while (v < values.getLength()) {
                        Node value = values.item(v);
                        String valueText = value.getTextContent();
                        classList.add(valueText);
                        ++v;
                    }
                    Attr classesAttr = attributeTag.getAttributeNode("classes");
                    if (classesAttr != null) {
                        if (classList.size() == 0) {
                            StringTokenizer tokenizer = new StringTokenizer(classesAttr.getValue());
                            while (tokenizer.hasMoreTokens()) {
                                classList.add(tokenizer.nextToken());
                            }
                        } else {
                            logging.logWarning("XML attribute 'classes' ignored since possible values are already defined by inner <value>...</value> tags.");
                        }
                    }
                    if (classList.size() == 0) {
                        if (type.equals("id")) {
                            logging.logNote("The ID attribute '" + name + "' is defined with a nominal value type but the possible values are not defined! " + "Although this often does not lead to problems (unlike for labels or regular nominal attributes) you might want " + "to specify the possible values by inner tags <value>first</value><value>second</value>....");
                        } else if (type.equals("label")) {
                            logging.logError("The label attribute (class) '" + name + "' is defined with a nominal value type but the possible values are not defined! " + "Please specify the possible values by inner tags <value>first</value><value>second</value>.... " + "Otherwise it might happen that the same nominal values of two example sets are handled in different ways which might cause flipped predictions.");
                        } else {
                            logging.logWarning("At least one of the attributes is defined with a nominal value type but the possible values are not defined! Please specify the possible values by inner tags <value>first</value><value>second</value>.... Otherwise it might happen that the same nominal values of two example sets are handled in different ways which might cause less accurate models.");
                        }
                    }
                }
                if (lastSourceCol == -1) {
                    lastSourceCol = firstSourceCol;
                }
                if (sourceColRequired) {
                    if (firstSourceCol < 0) {
                        throw new XMLException("sourcecol not defined for " + type + " '" + name + "'!");
                    }
                    if (lastSourceCol < firstSourceCol) {
                        throw new XMLException("sourcecol < sourcecol_end must hold.");
                    }
                }
                int col = firstSourceCol;
                while (col <= lastSourceCol) {
                    Attribute attribute;
                    int thisBlockType = blockType;
                    String theName = name;
                    if (lastSourceCol > firstSourceCol) {
                        theName = String.valueOf(name) + "_" + (col + 1);
                        if (col == firstSourceCol && blockType == 2) {
                            thisBlockType = 3;
                        }
                        if (col == lastSourceCol && blockType == 2) {
                            thisBlockType = 4;
                        }
                    }
                    if ((attribute = AttributeFactory.createAttribute(theName, valueType, thisBlockType)).isNominal() && classList != null) {
                        Iterator c = classList.iterator();
                        while (c.hasNext()) {
                            attribute.getMapping().mapString((String)c.next());
                        }
                    }
                    if (!attribute.isNominal() && classList != null && classList.size() != 0) {
                        LogService.getGlobal().log("Ignoring classes for non-nominal attribute " + theName + ".", 5);
                    }
                    attributeDataSources.add(new AttributeDataSource(attribute, file != null ? Tools.getFile(attributeDescriptionFile.getParentFile(), file) : defaultSource, col, type));
                    ++col;
                }
            }
            ++i;
        }
        return new AttributeDataSources(attributeDataSources, defaultSource);
    }

    public String toString() {
        return String.valueOf(this.attribute.getName()) + " (type: " + this.attributeType + ", value type: " + Ontology.VALUE_TYPE_NAMES[this.attribute.getValueType()] + ") from " + this.file.getName() + " (" + this.column + ")";
    }
}

