/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseHandler {
    public static final String[] OVERWRITE_MODES = new String[]{"none", "overwrite first, append then", "overwrite", "append"};
    public static final int OVERWRITE_MODE_NONE = 0;
    public static final int OVERWRITE_MODE_OVERWRITE_FIRST = 1;
    public static final int OVERWRITE_MODE_OVERWRITE = 2;
    public static final int OVERWRITE_MODE_APPEND = 3;
    private String databaseURL;
    private JDBCProperties properties;
    private Connection connection;

    public DatabaseHandler(String databaseURL, JDBCProperties properties) {
        this.databaseURL = databaseURL;
        this.properties = properties;
        this.connection = null;
    }

    public static DatabaseHandler getConnectedDatabaseHandler(String databaseURL, String username, String password, JDBCProperties properties, LoggingHandler logging) throws OperatorException, SQLException {
        if (password == null && username != null) {
            password = RapidMiner.getInputHandler().inputPassword("Password for user '" + username + "' required");
        }
        DatabaseHandler databaseHandler = new DatabaseHandler(databaseURL, properties);
        databaseHandler.connect(username, password, true);
        return databaseHandler;
    }

    public JDBCProperties getProperties() {
        return this.properties;
    }

    public void connect(String username, String passwd, boolean autoCommit) throws SQLException {
        if (this.connection != null) {
            throw new SQLException("connect: Connection to database '" + this.databaseURL + "' already exists!");
        }
        this.connection = username == null ? DriverManager.getConnection(this.databaseURL) : DriverManager.getConnection(this.databaseURL, username, passwd);
        this.connection.setAutoCommit(autoCommit);
    }

    public void disconnect() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Disconnect: was not connected.");
        }
        this.connection.close();
        this.connection = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Statement createStatement(boolean scrollableAndUpdatable) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not create a statement for '" + this.databaseURL + "': not connected.");
        }
        Statement statement = null;
        statement = scrollableAndUpdatable ? this.connection.createStatement(1005, 1008) : this.connection.createStatement(1003, 1007);
        return statement;
    }

    public PreparedStatement createPreparedStatement(String sqlString, boolean scrollableAndUpdatable) throws SQLException {
        if (this.connection == null) {
            throw new SQLException("Could not create a prepared statement for '" + this.databaseURL + "': not connected.");
        }
        PreparedStatement statement = null;
        statement = scrollableAndUpdatable ? this.connection.prepareStatement(sqlString, 1005, 1008) : this.connection.prepareStatement(sqlString, 1003, 1007);
        return statement;
    }

    public void commit() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Could not commit: no open connection to database '" + this.databaseURL + "' !");
        }
        this.connection.commit();
    }

    @Deprecated
    public ResultSet query(String sqlQuery) throws SQLException {
        if (!sqlQuery.toLowerCase().startsWith("select")) {
            throw new SQLException("Query: Only SQL-Statements starting with SELECT are allowed: " + sqlQuery);
        }
        Statement st = this.createStatement(true);
        ResultSet rs = st.executeQuery(sqlQuery);
        return rs;
    }

    public void addColumn(Attribute attribute, String tableName) throws SQLException {
        Statement statement = this.createStatement(false);
        boolean exists = false;
        try {
            ResultSet existingResultSet = statement.executeQuery("SELECT " + this.properties.getIdentifierQuoteOpen() + attribute.getName() + this.properties.getIdentifierQuoteClose() + " FROM " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " WHERE 0 = 1");
            if (existingResultSet.getMetaData().getColumnCount() > 0) {
                exists = true;
            }
            existingResultSet.close();
        }
        catch (SQLException existingResultSet) {
            // empty catch block
        }
        statement.close();
        if (exists) {
            this.removeColumn(attribute, tableName);
        }
        Statement st = null;
        try {
            st = this.connection.createStatement(1003, 1008);
            String query = "ALTER TABLE " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " ADD COLUMN " + this.properties.getIdentifierQuoteOpen() + attribute.getName() + this.properties.getIdentifierQuoteClose() + " " + (attribute.isNominal() ? String.valueOf(this.properties.getVarcharName()) + "(256)" : this.properties.getRealName());
            st.execute(query);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void removeColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = null;
        try {
            st = this.connection.createStatement(1003, 1008);
            String query = "ALTER TABLE " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " DROP COLUMN " + this.properties.getIdentifierQuoteOpen() + attribute.getName() + this.properties.getIdentifierQuoteClose();
            st.execute(query);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void createTable(ExampleSet exampleSet, String tableName, int overwriteMode, boolean firstAttempt, int defaultVarcharLength) throws SQLException {
        block11: {
            String createTableString;
            Statement statement;
            block10: {
                statement = this.createStatement(true);
                boolean exists = false;
                try {
                    ResultSet existingResultSet = statement.executeQuery("SELECT * FROM " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " WHERE 0 = 1");
                    if (existingResultSet.getMetaData().getColumnCount() > 0) {
                        exists = true;
                    }
                    existingResultSet.close();
                }
                catch (SQLException existingResultSet) {
                    // empty catch block
                }
                if (!exists) break block10;
                switch (overwriteMode) {
                    case 0: {
                        throw new SQLException("Table with name '" + tableName + "' already exists and overwriting mode is not activated." + Tools.getLineSeparator() + "Please change table name or activate overwriting mode.");
                    }
                    case 2: {
                        statement.executeUpdate("DROP TABLE " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose());
                        exampleSet.recalculateAllAttributeStatistics();
                        createTableString = this.getCreateTableString(exampleSet, tableName, defaultVarcharLength);
                        statement.executeUpdate(createTableString);
                        statement.close();
                        break;
                    }
                    case 1: {
                        if (firstAttempt) {
                            statement.executeUpdate("DROP TABLE " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose());
                            exampleSet.recalculateAllAttributeStatistics();
                            createTableString = this.getCreateTableString(exampleSet, tableName, defaultVarcharLength);
                            statement.executeUpdate(createTableString);
                            statement.close();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block11;
            }
            exampleSet.recalculateAllAttributeStatistics();
            createTableString = this.getCreateTableString(exampleSet, tableName, defaultVarcharLength);
            statement.executeUpdate(createTableString);
            statement.close();
        }
        PreparedStatement insertStatement = this.getInsertIntoTableStatement(tableName, exampleSet.getAttributes().allSize());
        for (Example example : exampleSet) {
            this.applyInsertIntoTable(insertStatement, example, exampleSet.getAttributes().allAttributeRoles());
        }
        insertStatement.close();
    }

    private PreparedStatement getInsertIntoTableStatement(String tableName, int size) throws SQLException {
        StringBuffer result = new StringBuffer("INSERT INTO " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " VALUES (");
        int i = 0;
        while (i < size) {
            if (i != 0) {
                result.append(", ");
            }
            result.append("?");
            ++i;
        }
        result.append(")");
        return this.createPreparedStatement(result.toString(), true);
    }

    private void applyInsertIntoTable(PreparedStatement statement, Example example, Iterator<AttributeRole> attributes) throws SQLException {
        int counter = 1;
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next().getAttribute();
            double value = example.getValue(attribute);
            if (Double.isNaN(value)) {
                int sqlType = !attribute.isNominal() ? (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3) ? 4 : 7) : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 5) ? 2004 : 12);
                statement.setNull(counter, sqlType);
            } else if (attribute.isNominal()) {
                String valueString = attribute.getMapping().mapIndex((int)value);
                while (valueString.indexOf(this.properties.getIdentifierQuoteOpen()) >= 0) {
                    valueString = valueString.replace(this.properties.getIdentifierQuoteOpen(), "_");
                }
                while (valueString.indexOf(this.properties.getIdentifierQuoteClose()) >= 0) {
                    valueString = valueString.replace(this.properties.getIdentifierQuoteClose(), "_");
                }
                while (valueString.indexOf(this.properties.getValueQuoteOpen()) >= 0) {
                    valueString = valueString.replace(this.properties.getValueQuoteOpen(), "_");
                }
                while (valueString.indexOf(this.properties.getValueQuoteClose()) >= 0) {
                    valueString = valueString.replace(this.properties.getValueQuoteClose(), "_");
                }
                statement.setString(counter, valueString);
            } else {
                statement.setDouble(counter, value);
            }
            ++counter;
        }
        statement.executeUpdate();
    }

    private String getCreateTableString(ExampleSet exampleSet, String tableName, int defaultVarcharLength) {
        StringBuffer result = new StringBuffer();
        result.append("CREATE TABLE " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + "(");
        Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
        boolean first = true;
        while (a.hasNext()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            AttributeRole attributeRole = a.next();
            result.append(this.getCreateAttributeString(attributeRole, defaultVarcharLength));
        }
        Attribute idAttribute = exampleSet.getAttributes().getId();
        if (idAttribute != null) {
            result.append(", PRIMARY KEY( " + this.properties.getIdentifierQuoteOpen() + idAttribute.getName() + this.properties.getIdentifierQuoteClose() + " )");
        }
        result.append(")");
        return result.toString();
    }

    private String getCreateAttributeString(AttributeRole attributeRole, int defaultVarcharLength) {
        Attribute attribute = attributeRole.getAttribute();
        StringBuffer result = new StringBuffer(String.valueOf(this.properties.getIdentifierQuoteOpen()) + attribute.getName() + this.properties.getIdentifierQuoteClose() + " ");
        if (attribute.isNominal()) {
            int varCharLength = 1;
            if (defaultVarcharLength != -1) {
                varCharLength = defaultVarcharLength;
            } else {
                for (String value : attribute.getMapping().getValues()) {
                    varCharLength = Math.max(varCharLength, value.length());
                }
            }
            if (attribute.getValueType() != 5) {
                result.append(String.valueOf(this.properties.getVarcharName()) + "(" + varCharLength + ")");
            } else {
                result.append(this.properties.getTextName());
            }
        } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 3)) {
            result.append(this.properties.getIntegerName());
        } else {
            result.append(this.properties.getRealName());
        }
        if (attributeRole.isSpecial() && attributeRole.getSpecialName().equals("id")) {
            result.append(" NOT NULL");
        }
        return result.toString();
    }

    public static int getRapidMinerTypeIndex(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 3;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 2004: 
            case 2005: {
                return 5;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2000: 
            case 2002: {
                return 1;
            }
            case 91: 
            case 92: 
            case 93: {
                return 1;
            }
        }
        return 1;
    }

    public static List<Attribute> createAttributes(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (rs == null) {
            throw new IllegalArgumentException("Cannot create attributes: ResultSet must not be null!");
        }
        try {
            metadata = rs.getMetaData();
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Could not create attribute list: ResultSet object seems closed.");
        }
        int numberOfColumns = metadata.getColumnCount();
        int column = 1;
        while (column <= numberOfColumns) {
            String name = metadata.getColumnLabel(column);
            Attribute attribute = AttributeFactory.createAttribute(name, DatabaseHandler.getRapidMinerTypeIndex(metadata.getColumnType(column)));
            attributes.add(attribute);
            ++column;
        }
        return attributes;
    }

    @Deprecated
    public static String getDatabaseName(Attribute attribute) {
        String name = attribute.getName();
        name = name.replaceAll("\\W", "_");
        return name;
    }

    public Map<String, List<ColumnIdentifier>> getAllTableMetaData() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Could not retrieve all table names: no open connection to database '" + this.databaseURL + "' !");
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        String[] types = new String[]{"TABLE"};
        ResultSet tableNames = metaData.getTables(null, null, "%", types);
        LinkedList<String> tableNameList = new LinkedList<String>();
        while (tableNames.next()) {
            String tableName = tableNames.getString(3);
            tableNameList.add(tableName);
        }
        LinkedHashMap<String, List<ColumnIdentifier>> result = new LinkedHashMap<String, List<ColumnIdentifier>>();
        for (String tableName : tableNameList) {
            try {
                List<ColumnIdentifier> columnNames = this.getAllColumnNames(tableName);
                result.put(tableName, columnNames);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return result;
    }

    private List<ColumnIdentifier> getAllColumnNames(String tableName) throws SQLException {
        if (tableName == null) {
            throw new SQLException("Cannot read column names: table name must not be null!");
        }
        Statement statement = null;
        try {
            ResultSetMetaData metadata;
            statement = this.createStatement(false);
            ResultSet rs = statement.executeQuery("SELECT * FROM " + this.properties.getIdentifierQuoteOpen() + tableName + this.properties.getIdentifierQuoteClose() + " WHERE 0 = 1");
            LinkedList<ColumnIdentifier> result = new LinkedList<ColumnIdentifier>();
            try {
                metadata = rs.getMetaData();
            }
            catch (NullPointerException npe) {
                throw new SQLException("Could not create column name list: ResultSet object seems closed.");
            }
            int numberOfColumns = metadata.getColumnCount();
            int column = 1;
            while (column <= numberOfColumns) {
                String name = metadata.getColumnLabel(column);
                result.add(new ColumnIdentifier(tableName, name));
                ++column;
            }
            LinkedList<ColumnIdentifier> linkedList = result;
            return linkedList;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

