/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.ROCPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROCData
implements Iterable<ROCPoint> {
    private final List<ROCPoint> points = new ArrayList<ROCPoint>();
    private double sumPos;
    private double sumNeg;
    private double bestIsometricsTP;

    public void addPoint(ROCPoint point) {
        this.points.add(point);
    }

    public void removePoint(ROCPoint point) {
        this.points.remove(point);
    }

    public int getNumberOfPoints() {
        return this.points.size();
    }

    public ROCPoint getPoint(int index) {
        return this.points.get(index);
    }

    public double getInterpolatedTruePositives(double d) {
        if (Tools.isZero(d)) {
            return 0.0;
        }
        if (Tools.isGreaterEqual(d, this.getTotalPositives())) {
            return this.getTotalPositives();
        }
        if (this.points.size() == 2) {
            if (Tools.isLess(d, 1.0)) {
                return this.sumPos % 2.0 == 0.0 ? this.sumPos / 2.0 : this.sumPos / 2.0 + 1.0;
            }
            return this.sumPos;
        }
        ROCPoint last = null;
        for (ROCPoint p : this) {
            double fpDivN = p.getFalsePositives() / this.getTotalNegatives();
            if (Tools.isGreater(fpDivN, d)) {
                if (last == null) {
                    return 0.0;
                }
                return last.getTruePositives();
            }
            last = p;
        }
        return this.getTotalPositives();
    }

    public double getInterpolatedThreshold(double d) {
        if (Tools.isZero(d)) {
            return 1.0;
        }
        if (Tools.isGreaterEqual(d, this.getTotalPositives())) {
            return 0.0;
        }
        if (this.points.size() == 2) {
            if (Tools.isLess(d, 1.0)) {
                return this.points.get(1).getConfidence();
            }
            return 0.0;
        }
        ROCPoint last = null;
        for (ROCPoint p : this) {
            double fpDivN = p.getFalsePositives() / this.getTotalNegatives();
            if (Tools.isGreater(fpDivN, d)) {
                if (last == null) {
                    return 1.0;
                }
                return last.getConfidence();
            }
            last = p;
        }
        if (last == null) {
            return 0.0;
        }
        return last.getConfidence();
    }

    @Override
    public Iterator<ROCPoint> iterator() {
        return this.points.iterator();
    }

    public void setTotalPositives(double sumPos) {
        this.sumPos = sumPos;
    }

    public double getTotalPositives() {
        return this.sumPos;
    }

    public void setTotalNegatives(double sumNeg) {
        this.sumNeg = sumNeg;
    }

    public double getTotalNegatives() {
        return this.sumNeg;
    }

    public void setBestIsometricsTPValue(double value) {
        this.bestIsometricsTP = value;
    }

    public double getBestIsometricsTPValue() {
        return this.bestIsometricsTP;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("ROC Points" + Tools.getLineSeparator());
        for (ROCPoint p : this.points) {
            result.append(p + Tools.getLineSeparator());
        }
        return result.toString();
    }
}

