/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class LogarithmDualis
extends PostfixMathCommand {
    private static final double LOG2 = Math.log(2.0);
    private static final Complex CLOG2 = new Complex(Math.log(2.0), 0.0);

    public LogarithmDualis() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.log(param));
    }

    public Object log(Object param) throws ParseException {
        if (param instanceof Complex) {
            return ((Complex)param).log().div(CLOG2);
        }
        if (param instanceof Number) {
            double num = ((Number)param).doubleValue();
            if (num >= 0.0) {
                return new Double(Math.log(num) / LOG2);
            }
            if (num == 0.0) {
                return new Double(Double.NaN);
            }
            Complex temp = new Complex(num);
            return temp.log().div(CLOG2);
        }
        throw new ParseException("Invalid parameter type");
    }
}

