/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.expressions;

import com.rapidminer.Process;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ParameterValue
extends PostfixMathCommand {
    private Process process;

    public ParameterValue(Process process) {
        this.numberOfParameters = 2;
        this.process = process;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        if (this.numberOfParameters != 2) {
            throw new ParseException("Needs two arguments: Operator and Parameter");
        }
        Object parameter = stack.pop();
        if (!(parameter instanceof String)) {
            throw new ParseException("Invalid parameter type, only strings are allowed for 'parameterValue'.");
        }
        Object operator = stack.pop();
        if (!(operator instanceof String)) {
            throw new ParseException("Invalid parameter type, only strings are allowed for 'parameterValue'.");
        }
        String operatorName = (String)operator;
        String parameterName = (String)parameter;
        try {
            stack.push(this.process.getOperator(operatorName).getParameter(parameterName));
        }
        catch (UndefinedParameterError e) {
            throw new ParseException("Unkown parameter as argument for 'parameterValue'.");
        }
        catch (NullPointerException e) {
            throw new ParseException("Unkown operator as argument for 'parameterValue'.");
        }
    }
}

