/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.optimization.ec.es;

import com.rapidminer.tools.math.optimization.ec.es.Individual;
import com.rapidminer.tools.math.optimization.ec.es.Population;
import com.rapidminer.tools.math.optimization.ec.es.PopulationOperator;
import java.util.LinkedList;
import java.util.Random;

public class Crossover
implements PopulationOperator {
    private double prob;
    private Random random;

    public Crossover(double prob, Random random) {
        this.prob = prob;
        this.random = random;
    }

    public void crossover(Individual i1, Individual i2) {
        double[] values1 = i1.getValues();
        double[] values2 = i2.getValues();
        boolean[] swap = new boolean[values1.length];
        int i = 0;
        while (i < swap.length) {
            swap[i] = this.random.nextBoolean();
            ++i;
        }
        i = 0;
        while (i < swap.length) {
            if (swap[i]) {
                double dummy = values1[i];
                values1[i] = values2[i];
                values2[i] = dummy;
            }
            ++i;
        }
        i1.setValues(values1);
        i2.setValues(values2);
    }

    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<Individual> matingPool = new LinkedList<Individual>();
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            matingPool.add((Individual)population.get(i).clone());
            ++i;
        }
        LinkedList<Individual> l = new LinkedList<Individual>();
        while (matingPool.size() > 1) {
            Individual p1 = (Individual)matingPool.remove(this.random.nextInt(matingPool.size()));
            Individual p2 = (Individual)matingPool.remove(this.random.nextInt(matingPool.size()));
            if (!(this.random.nextDouble() < this.prob)) continue;
            this.crossover(p1, p2);
            l.add(p1);
            l.add(p2);
        }
        population.addAll(l);
    }
}

