/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.divergences;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.BregmanDivergence;

public class LogisticLoss
extends BregmanDivergence {
    private static final long serialVersionUID = 6209100890792566974L;

    public double calculateDistance(double[] value1, double[] value2) {
        return value1[0] * Math.log(value1[0] / value2[0]) + (1.0 - value1[0]) * Math.log((1.0 - value1[0]) / (1.0 - value2[0]));
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
        Attributes attributes = exampleSet.getAttributes();
        if (attributes.size() != 1) {
            throw new OperatorException("The bregman divergence you've choosen is not applicable for the dataset! Proceeding with the 'Squared Euclidean distance' bregman divergence.");
        }
        for (Example example : exampleSet) {
            for (Attribute attribute : attributes) {
                double value = example.getValue(attribute);
                if (!(value <= 0.0) && !(value >= 1.0)) continue;
                throw new OperatorException("The bregman divergence you've choosen is not applicable for the dataset! Proceeding with the 'Squared Euclidean distance' bregman divergence.");
            }
        }
    }
}

