/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.OpdfGaussianFactory;
import be.ac.ulg.montefiore.run.jahmm.OpdfGaussianMixtureFactory;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationRealReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationRealWriter;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianMixtureReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianMixtureWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfGaussianWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RealRelatedObjects
implements RelatedObjs<ObservationReal> {
    public final String opdf;
    public final int nb;

    public RealRelatedObjects(String opdf) throws WrongArgumentsException {
        this.opdf = opdf;
        this.nb = CommandLineArguments.Arguments.NB_GAUSSIANS.getAsInt();
    }

    public ObservationRealReader observationReader() {
        return new ObservationRealReader();
    }

    public ObservationRealWriter observationWriter() {
        return new ObservationRealWriter();
    }

    @Override
    public OpdfFactory<? extends Opdf<ObservationReal>> opdfFactory() {
        if (this.opdf.equals("gaussian")) {
            return new OpdfGaussianFactory();
        }
        return new OpdfGaussianMixtureFactory(this.nb);
    }

    @Override
    public OpdfReader<? extends Opdf<ObservationReal>> opdfReader() {
        if (this.opdf.equals("gaussian")) {
            return new OpdfGaussianReader();
        }
        return new OpdfGaussianMixtureReader();
    }

    @Override
    public OpdfWriter<? extends Opdf<ObservationReal>> opdfWriter() {
        if (this.opdf.equals("gaussian")) {
            return new OpdfGaussianWriter();
        }
        return new OpdfGaussianMixtureWriter();
    }

    @Override
    public List<List<ObservationReal>> readSequences(Reader reader) throws FileFormatException, IOException {
        return ObservationSequencesReader.readSequences(this.observationReader(), reader);
    }

    @Override
    public MarkovGenerator<ObservationReal> generator(Hmm<ObservationReal> hmm) {
        return new MarkovGenerator<ObservationReal>(hmm);
    }
}

