/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.draw;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HmmDrawerDot<H extends Hmm<?>> {
    protected double minimumAij = 0.01;
    protected double minimumPi = 0.01;
    protected NumberFormat probabilityFormat = NumberFormat.getInstance();

    public HmmDrawerDot() {
        this.probabilityFormat.setMaximumFractionDigits(2);
    }

    protected String convert(H hmm) {
        String s = this.beginning();
        s = String.valueOf(s) + this.transitions((Hmm<?>)hmm);
        s = String.valueOf(s) + this.states(hmm);
        return String.valueOf(s) + this.ending();
    }

    protected String beginning() {
        return "digraph G {\n";
    }

    protected String transitions(Hmm<?> hmm) {
        String s = "";
        int i = 0;
        while (i < hmm.nbStates()) {
            int j = 0;
            while (j < hmm.nbStates()) {
                if (hmm.getAij(i, j) >= this.minimumAij) {
                    s = String.valueOf(s) + "\t" + i + " -> " + j + " [label=" + this.probabilityFormat.format(hmm.getAij(i, j)) + "];\n";
                }
                ++j;
            }
            ++i;
        }
        return s;
    }

    protected String states(H hmm) {
        String s = "";
        int i = 0;
        while (i < ((Hmm)hmm).nbStates()) {
            s = String.valueOf(s) + "\t" + i + " [";
            s = ((Hmm)hmm).getPi(i) >= this.minimumPi ? String.valueOf(s) + "shape=doublecircle, label=\"" + i + " - Pi= " + this.probabilityFormat.format(((Hmm)hmm).getPi(i)) + " - " + this.opdfLabel(hmm, i) + "\"" : String.valueOf(s) + "shape=circle, label=\"" + i + " - " + this.opdfLabel(hmm, i) + "\"";
            s = String.valueOf(s) + "];\n";
            ++i;
        }
        return s;
    }

    protected String opdfLabel(H hmm, int stateNb) {
        return "[ " + ((Hmm)hmm).getOpdf(stateNb).toString() + " ]";
    }

    protected String ending() {
        return "}\n";
    }

    public void write(H hmm, String filename) throws IOException {
        FileWriter fw = new FileWriter(filename);
        fw.write(this.convert(hmm));
        fw.close();
    }
}

