/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.MultiRandomDistribution;
import be.ac.ulg.montefiore.run.distributions.SimpleMatrix;
import java.util.Random;

public class MultiGaussianDistribution
implements MultiRandomDistribution {
    private final int dimension;
    private final double[] mean;
    private final double[][] covariance;
    private double[][] covarianceL = null;
    private double[][] covarianceInv = null;
    private double covarianceDet;
    private static final Random randomGenerator = new Random();
    private static final long serialVersionUID = -2438571303843585271L;

    public MultiGaussianDistribution(double[] mean, double[][] covariance) {
        if (!SimpleMatrix.isSquare(covariance)) {
            throw new IllegalArgumentException("Covariance must be a square matrix");
        }
        this.dimension = SimpleMatrix.nbRows(covariance);
        if (mean.length != this.dimension) {
            throw new IllegalArgumentException("mean and covariance dimensions don't match");
        }
        this.mean = SimpleMatrix.vector(mean);
        this.covariance = SimpleMatrix.matrix(covariance);
    }

    public MultiGaussianDistribution(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException();
        }
        this.dimension = dimension;
        this.mean = SimpleMatrix.vector(dimension);
        this.covariance = SimpleMatrix.matrixIdentity(dimension);
    }

    public int dimension() {
        return this.dimension;
    }

    public double[] mean() {
        return (double[])this.mean.clone();
    }

    public double[][] covariance() {
        return SimpleMatrix.matrix(this.covariance);
    }

    private double[][] covarianceL() {
        if (this.covarianceL == null) {
            this.covarianceL = SimpleMatrix.decomposeCholesky(this.covariance);
            this.covarianceDet = SimpleMatrix.determinantCholesky(this.covarianceL);
        }
        return this.covarianceL;
    }

    private double[][] covarianceInv() {
        if (this.covarianceInv == null) {
            this.covarianceInv = SimpleMatrix.inverseCholesky(this.covarianceL());
        }
        return this.covarianceInv;
    }

    public double covarianceDet() {
        this.covarianceL();
        return this.covarianceDet;
    }

    public double[] generate() {
        double[] d = SimpleMatrix.vector(this.dimension);
        int i = 0;
        while (i < this.dimension) {
            d[i] = randomGenerator.nextGaussian();
            ++i;
        }
        return SimpleMatrix.plus(SimpleMatrix.times(this.covarianceL(), d), this.mean);
    }

    public double probability(double[] v) {
        if (v.length != this.dimension) {
            throw new IllegalArgumentException("Argument array size is not compatible with this distribution");
        }
        double[][] vmm = SimpleMatrix.matrix(SimpleMatrix.minus(v, this.mean));
        double expArg = SimpleMatrix.times(SimpleMatrix.transpose(vmm), SimpleMatrix.times(this.covarianceInv(), vmm))[0][0] * -0.5;
        return Math.exp(expArg) / (Math.pow(Math.PI * 2, (double)this.dimension / 2.0) * Math.pow(this.covarianceDet(), 0.5));
    }
}

