/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentroidObservationVector
implements Centroid<ObservationVector> {
    private ObservationVector value;

    public CentroidObservationVector(ObservationVector o) {
        this.value = o.clone();
    }

    @Override
    public void reevaluateAdd(ObservationVector e, List<? extends ObservationVector> v) {
        double[] evalues = e.value;
        int i = 0;
        while (i < this.value.dimension()) {
            this.value.value[i] = (this.value.value[i] * (double)v.size() + evalues[i]) / (double)(v.size() + 1);
            ++i;
        }
    }

    @Override
    public void reevaluateRemove(ObservationVector e, List<? extends ObservationVector> v) {
        double[] evalues = e.value;
        int i = 0;
        while (i < this.value.dimension()) {
            this.value.value[i] = (this.value.value[i] * (double)v.size() - evalues[i]) / (double)(v.size() - 1);
            ++i;
        }
    }

    @Override
    public double distance(ObservationVector e) {
        ObservationVector diff = this.value.minus(e);
        double sum = 0.0;
        int i = 0;
        while (i < diff.dimension()) {
            sum += diff.value[i] * diff.value[i];
            ++i;
        }
        return Math.sqrt(sum);
    }
}

