/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansCalculator<K extends CentroidFactory<? super K>> {
    private ArrayList<Cluster<K>> clusters;

    public KMeansCalculator(int k, List<? extends K> elements) {
        boolean terminated;
        int i;
        CentroidFactory element;
        if (k <= 0) {
            throw new IllegalArgumentException("Illegal number of clusters");
        }
        this.clusters = new ArrayList(k);
        int clusterNb = 0;
        int elementNb = 0;
        while (elementNb < elements.size() && clusterNb < k && elements.size() - elementNb > k - clusterNb) {
            block11: {
                element = (CentroidFactory)elements.get(elementNb);
                i = 0;
                while (i < clusterNb) {
                    Cluster<K> cluster = this.clusters.get(i);
                    if (cluster.centroid().distance(element) == 0.0) {
                        cluster.add(element);
                        break block11;
                    }
                    ++i;
                }
                this.clusters.add(new Cluster(this, (CentroidFactory)elements.get(elementNb)));
                ++clusterNb;
            }
            ++elementNb;
        }
        while (clusterNb < k && elementNb < elements.size()) {
            this.clusters.add(new Cluster(this, (CentroidFactory)elements.get(elementNb)));
            ++elementNb;
            ++clusterNb;
        }
        while (clusterNb < k) {
            this.clusters.add(new Cluster());
            ++clusterNb;
        }
        while (elementNb < elements.size()) {
            element = (CentroidFactory)elements.get(elementNb);
            this.nearestCluster(element).add(element);
            ++elementNb;
        }
        do {
            terminated = true;
            i = 0;
            while (i < k) {
                Cluster<K> thisCluster = this.clusters.get(i);
                List<K> thisElements = thisCluster.elements();
                int j = 0;
                while (j < thisElements.size()) {
                    Cluster<CentroidFactory> nearestCluster;
                    CentroidFactory thisElement = (CentroidFactory)thisElements.get(j);
                    if (thisCluster.centroid().distance(thisElement) > 0.0 && thisCluster != (nearestCluster = this.nearestCluster(thisElement))) {
                        nearestCluster.add(thisElement);
                        thisCluster.remove(j);
                        terminated = false;
                    }
                    ++j;
                }
                ++i;
            }
        } while (!terminated);
    }

    private Cluster<K> nearestCluster(K element) {
        double distance = Double.MAX_VALUE;
        Cluster<K> cluster = null;
        int i = 0;
        while (i < this.clusters.size()) {
            double thisDistance = this.clusters.get(i).centroid().distance(element);
            if (distance > thisDistance) {
                distance = thisDistance;
                cluster = this.clusters.get(i);
            }
            ++i;
        }
        return cluster;
    }

    public Collection<K> cluster(int index) {
        return this.clusters.get(index).elements();
    }

    public int nbClusters() {
        return this.clusters.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Cluster<L extends CentroidFactory<? super L>> {
        private List<L> elements;
        private Centroid<? super L> centroid;

        public Cluster() {
            this.elements = new ArrayList<L>();
            this.centroid = null;
        }

        public Cluster(L e) {
            this.elements = new ArrayList<L>();
            this.elements.add(e);
            this.centroid = e.factor();
        }

        public List<L> elements() {
            return this.elements;
        }

        public void add(L e) {
            if (this.centroid == null) {
                this.centroid = e.factor();
            } else {
                this.centroid.reevaluateAdd(e, this.elements);
            }
            this.elements.add(e);
        }

        public void remove(int i) {
            this.centroid.reevaluateRemove(this.elements.get(i), this.elements);
            this.elements.remove(i);
        }

        public Centroid<? super L> centroid() {
            return this.centroid;
        }
    }
}

