/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfInteger
implements Opdf<ObservationInteger> {
    private double[] probabilities;
    private static final long serialVersionUID = 1L;

    public OpdfInteger(int nbEntries) {
        if (nbEntries <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.probabilities = new double[nbEntries];
        int i = 0;
        while (i < nbEntries) {
            this.probabilities[i] = 1.0 / (double)nbEntries;
            ++i;
        }
    }

    public OpdfInteger(double[] probabilities) {
        if (probabilities.length == 0) {
            throw new IllegalArgumentException("Invalid empty array");
        }
        this.probabilities = new double[probabilities.length];
        int i = 0;
        while (i < probabilities.length) {
            double d;
            this.probabilities[i] = probabilities[i];
            if (d < 0.0) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public int nbEntries() {
        return this.probabilities.length;
    }

    @Override
    public double probability(ObservationInteger o) {
        if (o.value > this.probabilities.length - 1) {
            throw new IllegalArgumentException("Wrong observation value");
        }
        return this.probabilities[o.value];
    }

    @Override
    public ObservationInteger generate() {
        double rand = Math.random();
        int i = 0;
        while (i < this.probabilities.length - 1) {
            double d;
            rand -= this.probabilities[i];
            if (d < 0.0) {
                return new ObservationInteger(i);
            }
            ++i;
        }
        return new ObservationInteger(this.probabilities.length - 1);
    }

    public void fit(ObservationInteger ... oa) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(oa));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fit(Collection<? extends ObservationInteger> co) {
        void var2_6;
        void var2_3;
        if (co.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        boolean bl = false;
        while (var2_3 < this.probabilities.length) {
            this.probabilities[var2_3] = 0.0;
            ++var2_3;
        }
        for (ObservationInteger observationInteger : co) {
            int n = observationInteger.value;
            this.probabilities[n] = this.probabilities[n] + 1.0;
        }
        boolean bl2 = false;
        while (var2_6 < this.probabilities.length) {
            void v1 = var2_6++;
            this.probabilities[v1] = this.probabilities[v1] / (double)co.size();
        }
    }

    public void fit(ObservationInteger[] o, double[] weights) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(o), weights);
    }

    @Override
    public void fit(Collection<? extends ObservationInteger> co, double[] weights) {
        if (co.isEmpty() || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(this.probabilities, 0.0);
        int i = 0;
        for (ObservationInteger observationInteger : co) {
            int n = observationInteger.value;
            this.probabilities[n] = this.probabilities[n] + weights[i++];
        }
    }

    public OpdfInteger clone() {
        try {
            return (OpdfInteger)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String s = "Integer distribution --- ";
        int i = 0;
        while (i < this.nbEntries()) {
            ObservationInteger oi = new ObservationInteger(i);
            s = String.valueOf(s) + numberFormat.format(this.probability(oi)) + (++i < this.nbEntries() ? " " : "");
        }
        return s;
    }
}

