/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Cli {
    public static void main(String ... args) throws IOException {
        try {
            System.exit(Cli.run(args));
        }
        catch (AbnormalTerminationException e) {
            System.err.println(e);
            System.exit(-1);
        }
    }

    public static int run(String ... args) throws IOException, AbnormalTerminationException {
        CommandLineArguments.reset();
        ActionHandler.Actions action = CommandLineArguments.parseAction(args);
        if (action == null) {
            throw new WrongArgumentsException("Valid action required");
        }
        ActionHandler actionHandler = null;
        try {
            actionHandler = action.handler().newInstance();
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
        actionHandler.parseArguments(args);
        try {
            actionHandler.act();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            return -1;
        }
        catch (FileFormatException e) {
            System.err.println(e);
            return -1;
        }
        return 0;
    }
}

