/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDataTable
implements DataTable,
Tableable {
    private List<DataTableListener> listeners = new LinkedList<DataTableListener>();
    private String name;

    public AbstractDataTable(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getColumnNames() {
        String[] result = new String[this.getNumberOfColumns()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColumnName(i);
            ++i;
        }
        return result;
    }

    public void addDataTableListener(DataTableListener dataTableListener) {
        this.listeners.add(dataTableListener);
    }

    public void removeDataTableListener(DataTableListener dataTableListener) {
        this.listeners.remove(dataTableListener);
    }

    protected void fireEvent() {
        Iterator i = new LinkedList<DataTableListener>(this.listeners).iterator();
        while (i.hasNext()) {
            ((DataTableListener)i.next()).dataTableUpdated(this);
        }
    }

    public String getValueAsString(DataTableRow row, int column) {
        if (this.isDate(column)) {
            return Tools.formatDate(new Date((long)row.getValue(column)));
        }
        if (this.isDateTime(column)) {
            return Tools.formatDateTime(new Date((long)row.getValue(column)));
        }
        if (this.isTime(column)) {
            return Tools.formatTime(new Date((long)row.getValue(column)));
        }
        if (this.isNominal(column)) {
            return this.mapIndex(column, (int)row.getValue(column));
        }
        return String.valueOf(row.getValue(column));
    }

    public void write(PrintWriter out) throws IOException {
        out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            out.print(String.valueOf(j != 0 ? "\t" : "# ") + this.getColumnName(j));
            ++j;
        }
        out.println();
        for (DataTableRow row : this) {
            int j2 = 0;
            while (j2 < this.getNumberOfColumns()) {
                out.print(String.valueOf(j2 != 0 ? "\t" : "") + this.getValueAsString(row, j2));
                ++j2;
            }
            out.println();
        }
        out.flush();
    }

    public boolean containsMissingValues() {
        for (DataTableRow row : this) {
            int j = 0;
            while (j < this.getNumberOfColumns()) {
                if (Double.isNaN(row.getValue(j))) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public int getRowNumber() {
        return this.getNumberOfRows();
    }

    public int getColumnNumber() {
        return this.getNumberOfColumns();
    }

    public String getCell(int row, int column) {
        double value = this.getRow(row).getValue(column);
        if (this.isDate(column)) {
            return Tools.formatDate(new Date((long)value));
        }
        if (this.isDateTime(column)) {
            return Tools.formatDateTime(new Date((long)value));
        }
        if (this.isTime(column)) {
            return Tools.formatTime(new Date((long)value));
        }
        if (this.isNominal(column)) {
            return this.mapIndex(column, (int)value);
        }
        return Tools.formatIntegerIfPossible(value);
    }

    public void prepareReporting() {
    }

    public void finishReporting() {
    }

    public boolean isFirstLineHeader() {
        return false;
    }

    public boolean isFirstColumnHeader() {
        return false;
    }
}

