/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class ConditionalAction
extends AbstractAction {
    private static final long serialVersionUID = -3581066203343247846L;
    private static final List<ConditionalAction> ALL_ACTIONS = new LinkedList<ConditionalAction>();
    public static final int DISALLOWED = -1;
    public static final int DONT_CARE = 0;
    public static final int MANDATORY = 1;
    public static final int OPERATOR_SELECTED = 0;
    public static final int OPERATOR_CHAIN_SELECTED = 1;
    public static final int ROOT_SELECTED = 2;
    public static final int SIBLINGS_EXIST = 3;
    public static final int CLIPBOARD_FILLED = 4;
    public static final int PROCESS_STOPPED = 5;
    public static final int PROCESS_PAUSED = 6;
    public static final int PROCESS_RUNNING = 7;
    public static final int XML_VIEW = 8;
    public static final int DESCRIPTION_VIEW = 9;
    public static final int NUMBER_OF_CONDITIONS = 10;
    private int[] conditions = new int[10];

    public ConditionalAction(String name) {
        this(name, null);
    }

    public ConditionalAction(String name, Icon icon) {
        super(name, icon);
        ALL_ACTIONS.add(this);
    }

    public void setCondition(int index, int condition) {
        this.conditions[index] = condition;
    }

    public static void updateAll(boolean[] states) {
        Iterator<ConditionalAction> i = ALL_ACTIONS.iterator();
        while (i.hasNext()) {
            i.next().update(states);
        }
    }

    private void update(boolean[] state) {
        boolean ok = true;
        int i = 0;
        while (i < this.conditions.length) {
            if (this.conditions[i] != 0 && (this.conditions[i] == 1 && !state[i] || this.conditions[i] == -1 && state[i])) {
                ok = false;
                break;
            }
            ++i;
        }
        this.setEnabled(ok);
    }
}

