/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class OperatorInfoPanel
extends JPanel {
    private static final long serialVersionUID = 3610550973456646750L;

    public OperatorInfoPanel(OperatorDescription description) {
        if (description == null) {
            this.add(new JLabel("No operator selected!"));
        } else {
            Operator operator = null;
            try {
                operator = description.createOperatorInstance();
            }
            catch (Exception e) {
                LogService.getGlobal().log("Cannot create operator: " + e.getMessage(), 5);
            }
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.ipadx = 10;
            c.weightx = 1.0;
            JLabel label = null;
            ImageIcon icon = description.getIcon();
            if (icon != null) {
                label = new JLabel(icon);
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
            }
            Component sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            this.add(sep);
            String deprecationInfo = description.getDeprecationInfo();
            if (deprecationInfo != null) {
                label = new JLabel("Deprecation Info");
                label.setToolTipText("The info about the deprecation state of this operator");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                this.add(label);
                JTextArea deprecationArea = new JTextArea(deprecationInfo);
                deprecationArea.setBorder(BorderFactory.createEmptyBorder(0, 7, 10, 7));
                deprecationArea.setEditable(false);
                deprecationArea.setLineWrap(true);
                deprecationArea.setWrapStyleWord(true);
                deprecationArea.setBackground(this.getBackground());
                deprecationArea.setToolTipText("The info about the deprecation state of this operator");
                c.gridwidth = 0;
                layout.setConstraints(deprecationArea, c);
                this.add(deprecationArea);
            }
            label = new JLabel("Group");
            label.setToolTipText("The group of the operator");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel(description.getGroup());
            label.setToolTipText("The group of the operator");
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel("Class");
            label.setToolTipText("The type of the operator");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            label = new JLabel(description.getName());
            label.setToolTipText("The type of the operator");
            c.gridwidth = 0;
            layout.setConstraints(label, c);
            this.add(label);
            sep = Box.createVerticalStrut(10);
            c.gridwidth = 0;
            layout.setConstraints(sep, c);
            this.add(sep);
            label = new JLabel("Input");
            label.setToolTipText("Expected input");
            c.gridwidth = -1;
            layout.setConstraints(label, c);
            this.add(label);
            if (operator != null) {
                label = new JLabel(SwingTools.getStringFromClassArray(operator.getInputClasses()));
                label.setToolTipText("Expected input");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
                label = new JLabel("Output");
                label.setToolTipText("Delivered output");
                c.gridwidth = -1;
                layout.setConstraints(label, c);
                this.add(label);
                label = new JLabel(SwingTools.getStringFromClassArray(operator.getOutputClasses()));
                label.setToolTipText("Delivered output");
                c.gridwidth = 0;
                layout.setConstraints(label, c);
                this.add(label);
                if (operator instanceof OperatorChain) {
                    OperatorChain chain = (OperatorChain)operator;
                    sep = Box.createVerticalStrut(10);
                    c.gridwidth = 0;
                    layout.setConstraints(sep, c);
                    this.add(sep);
                    if (chain.getMinNumberOfInnerOperators() == chain.getMaxNumberOfInnerOperators()) {
                        label = new JLabel("Inner Operators");
                        label.setToolTipText("Number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                        label.setToolTipText("Number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                    } else {
                        label = new JLabel("Min Inner");
                        label.setToolTipText("Minimum number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel(String.valueOf(((OperatorChain)operator).getMinNumberOfInnerOperators()));
                        label.setToolTipText("Minimum number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                        label = new JLabel("Max Inner");
                        label.setToolTipText("Maximum number of inner operators");
                        c.gridwidth = -1;
                        layout.setConstraints(label, c);
                        this.add(label);
                        int maxInner = ((OperatorChain)operator).getMaxNumberOfInnerOperators();
                        label = new JLabel(maxInner == Integer.MAX_VALUE ? "Max" : String.valueOf(maxInner));
                        label.setToolTipText("Maximum number of inner operators");
                        c.gridwidth = 0;
                        layout.setConstraints(label, c);
                        this.add(label);
                    }
                }
            }
            c.weighty = 1.0;
            JEditorPane descriptionText = new JEditorPane("text/html", "");
            StyleSheet css = ((HTMLEditorKit)descriptionText.getEditorKit()).getStyleSheet();
            css.addRule("P { margin : 0; font-family : sans-serif; font-size : 9px; font-style : normal; }");
            descriptionText.setToolTipText("The description of this operator");
            descriptionText.setEditable(false);
            descriptionText.setBackground(this.getBackground());
            String descriptionString = description.getLongDescriptionHTML();
            if (descriptionString == null) {
                descriptionString = description.getShortDescription();
            }
            descriptionText.setText("<P>" + descriptionString + "</P>");
            ExtendedJScrollPane textScrollPane = new ExtendedJScrollPane(descriptionText);
            textScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            c.gridwidth = 0;
            layout.setConstraints(textScrollPane, c);
            this.add(textScrollPane);
        }
    }
}

