/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class MultipleLinesLabel
extends JComponent
implements SwingConstants {
    private static final long serialVersionUID = -4783596538296904867L;
    private int lineHeight;
    private int lineAscent;
    private int maxWidth = -1;
    private int textHeight = -1;
    private int[] lineWidths;
    private int btnMarginWidth = 1;
    private String text = "";
    private boolean multiLine = true;
    private static Font labelFont = new Font("SansSerif", 0, 11);
    private int horizontalAlignment = 10;
    private int textAlignment = 10;
    private int verticalAlignment = 0;
    private FontMetrics fontMetrics;
    private Vector<String> vector;
    private boolean needUpdate = true;

    public MultipleLinesLabel() {
        this("", 0, 0, 1);
    }

    public MultipleLinesLabel(String text) {
        this(text, 10, 10, 1);
    }

    public MultipleLinesLabel(String text, int horizontalAlignment) {
        this(text, horizontalAlignment, 10, 0);
    }

    public MultipleLinesLabel(String text, int horizontalAlignment, int textAlignment) {
        this(text, horizontalAlignment, textAlignment, 0);
    }

    public MultipleLinesLabel(String str, int horizontalAlignment, int textAlignment, int verticalAlignment) {
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("textHighlight"));
        this.setFont(labelFont);
        this.setText(str);
        this.horizontalAlignment = horizontalAlignment;
        this.textAlignment = textAlignment;
        this.verticalAlignment = verticalAlignment;
        this.needUpdate = true;
    }

    private void updateTextVector() {
        this.vector = new Vector();
        int w = this.getWidth();
        if (w > 6) {
            w -= 4;
        }
        int counter = 0;
        char[] ca = this.text.toCharArray();
        String tempStr = "";
        Vector<String> sentVec = new Vector<String>();
        char lastChar = ca[0];
        tempStr = String.valueOf(tempStr) + lastChar;
        int i = 1;
        while (i < ca.length) {
            if (lastChar == ' ') {
                if (ca[i] == ' ') {
                    tempStr = String.valueOf(tempStr) + ca[i];
                } else {
                    sentVec.add(tempStr);
                    tempStr = String.valueOf(ca[i]);
                }
            } else if (ca[i] == ' ') {
                sentVec.add(tempStr);
                tempStr = String.valueOf(ca[i]);
            } else {
                tempStr = String.valueOf(tempStr) + ca[i];
            }
            lastChar = ca[i];
            ++i;
        }
        if (!tempStr.equals("")) {
            sentVec.add(tempStr);
        }
        Enumeration els = sentVec.elements();
        StringBuffer lineStr = new StringBuffer();
        while (els.hasMoreElements()) {
            String str = els.nextElement().toString();
            ++counter;
            if (this.fontMetrics.stringWidth(str) <= w) {
                if (this.fontMetrics.stringWidth(lineStr + str) <= w) {
                    lineStr.append(str);
                    continue;
                }
                if (!lineStr.equals("")) {
                    this.vector.add(lineStr.toString());
                    lineStr = new StringBuffer();
                }
                lineStr = new StringBuffer(str);
                continue;
            }
            if (!lineStr.equals("")) {
                this.vector.add(lineStr.toString());
                lineStr = new StringBuffer();
            }
            ca = str.toCharArray();
            int first = 0;
            int i2 = 0;
            while (i2 < ca.length) {
                if (this.fontMetrics.stringWidth(str.substring(first, i2)) > w) {
                    this.vector.add(str.substring(first, i2 - 1));
                    first = i2 - 1;
                }
                ++i2;
            }
            lineStr = new StringBuffer(str.substring(first, str.length()));
        }
        if (lineStr.length() > 0) {
            this.vector.add(lineStr.toString());
        }
    }

    private void recalculateDimension() {
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.lineHeight = this.fontMetrics.getHeight();
        this.lineAscent = this.fontMetrics.getAscent();
        this.lineWidths = new int[this.vector.size()];
        this.maxWidth = 0;
        int i = 0;
        while (i < this.vector.size()) {
            this.lineWidths[i] = this.fontMetrics.stringWidth(this.vector.elementAt(i));
            this.maxWidth = Math.max(this.maxWidth, this.lineWidths[i]);
            ++i;
        }
        this.maxWidth += 2 * this.btnMarginWidth;
        this.textHeight = this.vector.size() * this.lineHeight;
        this.revalidate();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 20);
    }

    public Dimension getMinimumSize1() {
        if (this.maxWidth == -1 || this.textHeight == -1) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.maxWidth + insets.left + insets.right, this.textHeight + insets.top + insets.bottom);
    }

    private void paintOneLine(Graphics g, Dimension d, Insets insets, int y) {
        int ha = this.getBidiHorizontalAlignment(this.horizontalAlignment);
        int ww = this.fontMetrics.stringWidth(this.text);
        int x = 0;
        if (ha == 2) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            if (ha == 2) {
                x = insets.left;
            } else if (ha == 4) {
                x = this.maxWidth - ww + insets.left;
            } else if (ha == 0) {
                x = insets.left + (this.maxWidth - ww) / 2;
            }
        } else if (ha == 4) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            if (ha == 2) {
                x = d.width - this.maxWidth - insets.right;
            } else if (ha == 4) {
                x = d.width - ww - insets.right;
            } else if (ha == 0) {
                x = d.width - this.maxWidth - insets.right + (this.maxWidth - ww) / 2;
            }
        } else if (ha == 0) {
            ha = this.getBidiHorizontalAlignment(this.textAlignment);
            int clientAreaWidth = d.width - insets.left - insets.right;
            if (ha == 2) {
                x = insets.left + (clientAreaWidth - this.maxWidth) / 2;
            } else if (ha == 4) {
                x = insets.left + (clientAreaWidth - this.maxWidth) / 2 + (this.maxWidth - ww);
            } else if (ha == 0) {
                x = insets.left + (clientAreaWidth - ww) / 2;
            }
        }
        int re = (this.getHeight() + this.fontMetrics.getHeight()) / 2 - 2;
        int w = this.fontMetrics.stringWidth(this.text);
        int last = 0;
        if (w > this.getWidth()) {
            char[] ca = this.text.toCharArray();
            last = ca.length;
            int i = 0;
            while (i < ca.length) {
                if (this.fontMetrics.stringWidth(String.valueOf(this.text.substring(0, i)) + "..." + 2) > this.getWidth()) {
                    last = i - 1;
                    g.drawString(String.valueOf(this.text.substring(0, last)) + "...", 2, re);
                    return;
                }
                ++i;
            }
        }
        g.drawString(this.text, x, re);
    }

    protected void paintComponent(Graphics g) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        super.paintComponent(g);
        this.updateInfo();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        Dimension d = this.getSize();
        if (d.width != this.maxWidth || d.height != this.textHeight) {
            this.recalculateDimension();
        }
        Insets insets = this.getInsets();
        int y = 0;
        y = insets.top + this.lineAscent;
        if (this.multiLine) {
            this.paintMultiLine(g, d, insets, y);
        } else {
            this.paintOneLine(g, d, insets, y);
        }
    }

    private void paintMultiLine(Graphics g, Dimension d, Insets insets, int y) {
        int i = 0;
        while (i < this.vector.size()) {
            int x = 0;
            int clientAreaWidth = d.width - insets.left - insets.right;
            x = insets.left + (clientAreaWidth - this.lineWidths[i]) / 2;
            g.drawString(this.vector.elementAt(i), x += this.btnMarginWidth, y);
            y += this.lineHeight;
            ++i;
        }
    }

    private void updateInfo() {
        if (this.text == null || this.text == "") {
            return;
        }
        if (!this.needUpdate) {
            return;
        }
        this.updateTextVector();
        this.recalculateDimension();
        this.needUpdate = false;
    }

    public void setText(String str) {
        this.text = str;
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.needUpdate = true;
    }

    private int getBidiHorizontalAlignment(int ha) {
        if (ha == 10) {
            ha = this.getComponentOrientation().isLeftToRight() ? 2 : 4;
        } else if (ha == 11) {
            ha = this.getComponentOrientation().isLeftToRight() ? 4 : 2;
        }
        return ha;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.needUpdate = true;
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.needUpdate = true;
        this.repaint();
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
        this.needUpdate = true;
        this.repaint();
    }

    public void setMultiLine(boolean b) {
        this.multiLine = b;
        this.needUpdate = true;
        this.updateInfo();
    }

    public void setNeed_update(boolean need_update) {
        this.needUpdate = need_update;
    }

    public int getPreferredLineWidth() {
        return this.fontMetrics.stringWidth(this.text);
    }

    public int getPreferredLineHeight() {
        return this.fontMetrics.getHeight();
    }

    public int getLineDiff() {
        if (this.vector.size() > 1) {
            return this.fontMetrics.getHeight() * (this.vector.size() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        if (this.multiLine) {
            return new Dimension(this.getPreferredLineWidth(), this.fontMetrics.getHeight() * this.vector.size());
        }
        return new Dimension(this.getPreferredLineWidth(), this.fontMetrics.getHeight());
    }
}

