/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.ColorProvider;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class ColorizedLineAndShapeRenderer
extends XYLineAndShapeRenderer {
    private static final long serialVersionUID = 6884606136158793687L;
    public static final Stroke STROKE = new BasicStroke(0.75f, 1, 1);
    private double[] colorValues;
    private double minColor;
    private double maxColor;
    private ColorProvider colorProvider = new ColorProvider();

    public ColorizedLineAndShapeRenderer(double[] colorValues) {
        this.colorValues = colorValues;
        this.minColor = Double.POSITIVE_INFINITY;
        this.maxColor = Double.NEGATIVE_INFINITY;
        if (this.colorValues != null) {
            double[] dArray = this.colorValues;
            int n = this.colorValues.length;
            int n2 = 0;
            while (n2 < n) {
                double d = dArray[n2];
                this.minColor = MathFunctions.robustMin(this.minColor, d);
                this.maxColor = MathFunctions.robustMax(this.maxColor, d);
                ++n2;
            }
        }
    }

    public double getMinColorValue() {
        return this.minColor;
    }

    public double getMaxColorValue() {
        return this.maxColor;
    }

    public Paint getItemPaint(int series, int item) {
        if (this.colorValues == null || this.minColor == this.maxColor) {
            return Color.RED;
        }
        double normalized = (this.colorValues[series] - this.minColor) / (this.maxColor - this.minColor);
        return this.colorProvider.getPointColor(normalized);
    }

    public Stroke getItemStroke(int series, int item) {
        return STROKE;
    }

    public boolean getItemShapeVisible(int series, int item) {
        return false;
    }
}

