/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = -4547732551646588939L;
    private transient ParameterTypeList type;
    private transient Operator operator;

    public ListPropertyTable(ParameterTypeList type, List<String[]> parameterList, Operator operator) {
        super(new String[]{type.getKey(), type.getValueType().getKey()});
        this.type = type;
        this.operator = operator;
        this.updateTableData(parameterList.size());
        ListPropertyTable.updateEditorsAndRenderers(this);
        Iterator<String[]> i = parameterList.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] keyValue = i.next();
            this.getModel().setValueAt(keyValue[0], j, 0);
            this.getModel().setValueAt(keyValue[1], j, 1);
            ++j;
        }
    }

    public void addRow() {
        this.getDefaultModel().addRow(new Object[]{"", this.type.getValueType().getDefaultValue()});
        ListPropertyTable.updateEditorsAndRenderers(this);
        int lastIndex = this.getRowCount() - 1;
        this.getModel().setValueAt(this.getKeyEditor(lastIndex).getCellEditorValue(), lastIndex, 0);
    }

    public void removeSelected() {
        int[] selectedRow = this.getSelectedRows();
        int i = selectedRow.length - 1;
        while (i >= 0) {
            this.getDefaultModel().removeRow(selectedRow[i]);
            --i;
        }
        this.getDefaultModel().fireTableStructureChanged();
    }

    public void getParameterList(List<String[]> list) {
        list.clear();
        int i = 0;
        while (i < this.getModel().getRowCount()) {
            String firstString = null;
            Object firstObject = this.getModel().getValueAt(i, 0);
            if (firstObject instanceof String) {
                firstString = (String)firstObject;
            } else if (firstObject != null) {
                firstString = firstObject.toString();
            }
            String secondString = null;
            Object secondObject = this.getModel().getValueAt(i, 1);
            if (secondObject instanceof String) {
                secondString = (String)secondObject;
            } else if (secondObject != null) {
                secondString = secondObject.toString();
            }
            list.add(new String[]{firstString, secondString});
            ++i;
        }
    }

    @Override
    public Operator getOperator(int row) {
        return this.operator;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.type.getValueType();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }
}

