/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DistributionModelTableRenderer
extends AbstractTableModelTableRenderer {
    public TableModel getTableModel(Object renderable, IOContainer ioContainer) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        if (distributionModel != null) {
            return new DistributionTableModel(distributionModel);
        }
        return null;
    }

    public String getName() {
        return "Distribution Table";
    }

    public boolean isAutoresize() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistributionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2196512073454635516L;
        private DistributionModel model;
        private int totalNumberOfParameters = 0;
        private int[] rowDistributionIndices;
        private int[] rowParameterIndices;

        public DistributionTableModel(DistributionModel model) {
            this.model = model;
            int i = 0;
            while (i < model.getNumberOfAttributes()) {
                this.totalNumberOfParameters += model.getDistribution(0, i).getNumberOfParameters();
                ++i;
            }
            this.rowDistributionIndices = new int[this.totalNumberOfParameters];
            this.rowParameterIndices = new int[this.totalNumberOfParameters];
            int row = 0;
            int i2 = 0;
            while (i2 < model.getNumberOfAttributes()) {
                int j = 0;
                while (j < model.getDistribution(0, i2).getNumberOfParameters()) {
                    this.rowDistributionIndices[row] = i2;
                    this.rowParameterIndices[row] = j++;
                    ++row;
                }
                ++i2;
            }
        }

        @Override
        public int getColumnCount() {
            return this.model.getNumberOfClasses() + 2;
        }

        @Override
        public int getRowCount() {
            return this.totalNumberOfParameters;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.model.getAttributeNames()[this.rowDistributionIndices[rowIndex]];
                }
                case 1: {
                    return this.model.getDistribution(0, this.rowDistributionIndices[rowIndex]).getParameterName(this.rowParameterIndices[rowIndex]);
                }
            }
            return this.model.getDistribution(columnIndex - 2, this.rowDistributionIndices[rowIndex]).getParameterValue(this.rowParameterIndices[rowIndex]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            return Double.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            if (columnIndex == 1) {
                return "Parameter";
            }
            return this.model.getClassName(columnIndex - 2);
        }
    }
}

