/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.viewer;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.viewer.DataViewerTable;
import com.rapidminer.report.Tableable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataViewer
extends JPanel
implements Tableable {
    private static final long serialVersionUID = -8114228636932871865L;
    private static final int DEFAULT_MAX_SIZE_FOR_FILTERING = 100000;
    private JLabel generalInfo = new JLabel();
    private DataViewerTable dataTable = new DataViewerTable();
    private JLabel filterCounter = new JLabel();
    private transient ExampleSet originalExampleSet;

    public DataViewer(ExampleSet exampleSet, boolean providedFilter) {
        super(new BorderLayout());
        this.originalExampleSet = exampleSet;
        JPanel infoPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        infoPanel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        StringBuffer infoText = new StringBuffer("ExampleSet (");
        int noExamples = this.originalExampleSet.size();
        infoText.append(noExamples);
        infoText.append(noExamples == 1 ? " example, " : " examples, ");
        int noSpecial = this.originalExampleSet.getAttributes().specialSize();
        infoText.append(noSpecial);
        infoText.append(noSpecial == 1 ? " special attribute, " : " special attributes, ");
        int noRegular = this.originalExampleSet.getAttributes().size();
        infoText.append(noRegular);
        infoText.append(noRegular == 1 ? " regular attribute)" : " regular attributes)");
        this.generalInfo.setText(infoText.toString());
        layout.setConstraints(this.generalInfo, c);
        infoPanel.add(this.generalInfo);
        if (providedFilter) {
            JPanel filterPanel = new JPanel(new FlowLayout(0));
            filterPanel.add(new JLabel("View Filter "));
            this.updateFilterCounter(this.originalExampleSet);
            filterPanel.add(this.filterCounter);
            LinkedList<String> applicableFilterNames = new LinkedList<String>();
            int i = 0;
            while (i < ConditionedExampleSet.KNOWN_CONDITION_NAMES.length) {
                String conditionName = ConditionedExampleSet.KNOWN_CONDITION_NAMES[i];
                try {
                    ConditionedExampleSet.createCondition(conditionName, exampleSet, null);
                    applicableFilterNames.add(conditionName);
                }
                catch (ConditionCreationException conditionCreationException) {
                    // empty catch block
                }
                ++i;
            }
            String[] applicableConditions = new String[applicableFilterNames.size()];
            applicableFilterNames.toArray(applicableConditions);
            final JComboBox<String> filterSelector = new JComboBox<String>(applicableConditions);
            filterSelector.setToolTipText("These filters can be used to skip examples in the view fulfilling the filter condition.");
            filterSelector.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DataViewer.this.updateFilter((String)filterSelector.getSelectedItem());
                }
            });
            int maxNumberBeforeFiltering = 100000;
            String maxString = System.getProperty("rapidminer.gui.max_statistics_rows");
            if (maxString != null) {
                try {
                    maxNumberBeforeFiltering = Integer.parseInt(maxString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (exampleSet.size() > maxNumberBeforeFiltering) {
                filterSelector.setEnabled(false);
            }
            filterPanel.add(filterSelector);
            c.weightx = 0.0;
            c.gridwidth = 0;
            layout.setConstraints(filterPanel, c);
            infoPanel.add(filterPanel);
        }
        this.add((Component)infoPanel, "North");
        ExtendedJScrollPane tableScrollPane = new ExtendedJScrollPane(this.dataTable);
        this.add((Component)tableScrollPane, "Center");
        this.setExampleSet(exampleSet);
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.dataTable.setExampleSet(exampleSet);
    }

    private void updateFilter(String conditionName) {
        ExampleSet filteredExampleSet = this.originalExampleSet;
        try {
            Condition condition = ConditionedExampleSet.createCondition(conditionName, this.originalExampleSet, null);
            filteredExampleSet = new ConditionedExampleSet(this.originalExampleSet, condition);
        }
        catch (ConditionCreationException ex) {
            this.originalExampleSet.getLog().logError("Cannot create condition '" + conditionName + "' for filtered data view: " + ex.getMessage() + ". Using original data set view...");
            filteredExampleSet = this.originalExampleSet;
        }
        this.updateFilterCounter(filteredExampleSet);
        this.setExampleSet(filteredExampleSet);
    }

    private void updateFilterCounter(ExampleSet filteredExampleSet) {
        this.filterCounter.setText("(" + filteredExampleSet.size() + " / " + this.originalExampleSet.size() + "): ");
    }

    public void prepareReporting() {
        this.dataTable.prepareReporting();
    }

    public void finishReporting() {
        this.dataTable.finishReporting();
    }

    public String getColumnName(int columnIndex) {
        return this.dataTable.getColumnName(columnIndex);
    }

    public String getCell(int row, int column) {
        return this.dataTable.getCell(row, column);
    }

    public int getColumnNumber() {
        return this.dataTable.getColumnNumber();
    }

    public int getRowNumber() {
        return this.dataTable.getRowNumber();
    }

    public boolean isFirstLineHeader() {
        return false;
    }

    public boolean isFirstColumnHeader() {
        return false;
    }
}

