/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.viewer.ContainerModelViewer;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedModel
extends AbstractModel
implements Iterable<Model> {
    private static final long serialVersionUID = -4954107247345450771L;
    private List<Model> models = new ArrayList<Model>();

    public GroupedModel() {
        super(null);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        for (Model model : this.models) {
            exampleSet = model.apply(exampleSet);
        }
        return exampleSet;
    }

    @Override
    public Iterator<Model> iterator() {
        return this.models.iterator();
    }

    @Override
    public boolean isUpdatable() {
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            if (i.next().isUpdatable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateModel(ExampleSet updateExampleSet) throws OperatorException {
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            i.next().updateModel(updateExampleSet);
        }
    }

    @Override
    public String getName() {
        return "GroupedModel";
    }

    public void prependModel(Model model) {
        this.models.add(0, model);
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public void removeModel(Model model) {
        this.models.remove(model);
    }

    public int getNumberOfModels() {
        return this.models.size();
    }

    public Model getModel(int index) {
        return this.models.get(index);
    }

    public <T extends Model> T getModel(Class<T> desiredClass) {
        for (Model model : this.models) {
            if (!desiredClass.isAssignableFrom(model.getClass())) continue;
            return (T)model;
        }
        return null;
    }

    @Override
    public void setParameter(String key, Object value) throws OperatorException {
        boolean ok = false;
        Iterator<Model> i = this.models.iterator();
        while (i.hasNext()) {
            try {
                i.next().setParameter(key, value);
                ok = true;
            }
            catch (OperatorException operatorException) {
                // empty catch block
            }
        }
        if (!ok) {
            throw new UserError(null, 204, this.getName(), key);
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("Model [");
        int i = 0;
        while (i < this.getNumberOfModels()) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.getModel(i).toString());
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public String toResultString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getNumberOfModels()) {
            result.append(String.valueOf(i + 1) + ". " + this.getModel(i).toResultString() + Tools.getLineSeparator());
            ++i;
        }
        return result.toString();
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        if (this.getNumberOfModels() == 0) {
            return new JLabel("<html><h1>Empty model container.</h1></html>");
        }
        if (this.getNumberOfModels() == 1) {
            return this.getModel(0).getVisualizationComponent(container);
        }
        return new ExtendedJScrollPane(new ContainerModelViewer(this, container));
    }
}

