/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.Process;
import com.rapidminer.ProcessListener;
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.NonEqualTypeCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessRootOperator
extends OperatorChain {
    public static final String PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED = "rapidminer.general.randomseed";
    public static final String PARAMETER_ENCODING = "encoding";
    public static final String PARAMETER_LOGVERBOSITY = "logverbosity";
    public static final String PARAMETER_LOGFILE = "logfile";
    public static final String PARAMETER_RESULTFILE = "resultfile";
    public static final String PARAMETER_TEMP_DIR = "temp_dir";
    public static final String PARAMETER_DELETE_TEMP_FILES = "delete_temp_files";
    public static final String PARAMETER_RANDOM_SEED = "random_seed";
    public static final String PARAMETER_SEND_MAIL = "send_mail";
    public static final String[] PARAMETER_SEND_MAIL_OPTIONS = new String[]{"always", "never", "for_long_processes"};
    public static final int PARAMETER_SEND_MAIL_ALWAYS = 0;
    public static final int PARAMETER_SEND_MAIL_NEVER = 1;
    public static final int PARAMETER_SEND_MAIL_FOR_LONG = 2;
    public static final String PARAMETER_PROCESS_DURATION_FOR_MAIL = "process_duration_for_mail";
    public static final String PARAMETER_NOTIFICATION_EMAIL = "notification_email";
    private List<ProcessListener> listenerList = new LinkedList<ProcessListener>();
    private Process process;

    static {
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED, "The default random seed (-1: random random seed).", -1, Integer.MAX_VALUE, 2001));
    }

    public ProcessRootOperator(OperatorDescription description) {
        this(description, null);
    }

    public ProcessRootOperator(OperatorDescription description, Process process) {
        super(description);
        this.addValue(new ValueDouble("memory", "The current memory usage."){

            public double getDoubleValue() {
                return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
        });
        this.setProcess(process);
        this.rename("Root");
    }

    public void setProcess(Process process) {
        this.process = process;
        this.registerOperator(this.process);
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return true;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    public void addProcessListener(ProcessListener l) {
        this.listenerList.add(l);
    }

    public void removeProcessListener(ProcessListener l) {
        this.listenerList.remove(l);
    }

    public void clearListeners() {
        this.listenerList.clear();
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        Iterator<ProcessListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().processStarts(this.process);
        }
    }

    protected void processStartedOperator(Operator op) {
        for (ProcessListener listener : this.listenerList) {
            listener.processStartedOperator(this.process, op);
        }
    }

    protected void processFinishedOperator(Operator op) {
        for (ProcessListener listener : this.listenerList) {
            listener.processFinishedOperator(this.process, op);
        }
    }

    @Override
    public void processFinished() throws OperatorException {
        super.processFinished();
        Iterator<ProcessListener> i = this.listenerList.iterator();
        while (i.hasNext()) {
            i.next().processEnded(this.process);
        }
    }

    public void sendEmail(IOContainer results, Throwable e) throws UndefinedParameterError {
        String email;
        int sendEmail = this.getParameterAsInt(PARAMETER_SEND_MAIL);
        if (sendEmail == 1) {
            return;
        }
        if (sendEmail == 2) {
            long minTimeToSendEmail = this.getParameterAsInt(PARAMETER_PROCESS_DURATION_FOR_MAIL) * 60 * 1000;
            if (System.currentTimeMillis() - this.getStartTime() < minTimeToSendEmail) {
                return;
            }
        }
        if ((email = this.getParameterAsString(PARAMETER_NOTIFICATION_EMAIL)) == null) {
            return;
        }
        this.log("Sending notification email to '" + email + "'");
        String name = email;
        int at = name.indexOf("@");
        if (at >= 0) {
            name = name.substring(0, at);
        }
        String subject = "Process " + this.getName() + " finished";
        StringBuilder content = new StringBuilder("Hello " + name + "," + Tools.getLineSeparator() + Tools.getLineSeparator());
        content.append("I'm sending you a notification message on your process '" + this.getName() + "'." + Tools.getLineSeparator());
        File logFile = this.getLog().getLogFile();
        if (logFile != null) {
            content.append("Logfile is file://" + logFile.getAbsolutePath() + Tools.getLineSeparator() + Tools.getLineSeparator());
        }
        if (e != null) {
            content.append("Process failed: " + e.toString());
            subject = "Process " + this.getName() + " failed";
        }
        if (results != null) {
            content.append(String.valueOf(Tools.getLineSeparator()) + Tools.getLineSeparator() + "Results:");
            int i = 0;
            try {
                while (true) {
                    ResultObject result = results.get(ResultObject.class, i);
                    content.append(String.valueOf(Tools.getLineSeparator()) + Tools.getLineSeparator() + Tools.getLineSeparator() + result.toResultString());
                    ++i;
                }
            }
            catch (MissingIOObjectException missingIOObjectException) {
                // empty catch block
            }
        }
        Tools.sendEmail(email, subject, content.toString());
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        int defaultTime;
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_LOGVERBOSITY, "Log verbosity level.", LogService.LOG_VERBOSITY_NAMES, 3);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile(PARAMETER_LOGFILE, "File to write logging information to.", "log", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_RESULTFILE, "File to write inputs of the ResultWriter operators to.", "res", true));
        int seed = 2001;
        String seedProperty = System.getProperty(PROPERTY_RAPIDMINER_GENERAL_RANDOMSEED);
        try {
            if (seedProperty != null) {
                seed = Integer.parseInt(seedProperty);
            }
        }
        catch (NumberFormatException e) {
            this.logWarning("Bad integer in property 'rapidminer.general.randomseed', using default seed (2001).");
        }
        types.add(new ParameterTypeInt(PARAMETER_RANDOM_SEED, "Global random seed for random generators (-1 for initialization by system time).", Integer.MIN_VALUE, Integer.MAX_VALUE, seed));
        types.add(new ParameterTypeCategory(PARAMETER_SEND_MAIL, "Send email upon completion of the proces.", PARAMETER_SEND_MAIL_OPTIONS, 1));
        ParameterTypeString parameterRecepient = new ParameterTypeString(PARAMETER_NOTIFICATION_EMAIL, "Email address for the notification mail.", System.getProperty("rapidminer.tools.mail.default_recipient"));
        parameterRecepient.registerDependencyCondition(new NonEqualTypeCondition(this, PARAMETER_SEND_MAIL, true, 1));
        types.add(parameterRecepient);
        try {
            defaultTime = Integer.parseInt(System.getProperty("rapidminer.tools.mail.process_duration_for_mail"));
        }
        catch (NumberFormatException e) {
            defaultTime = 30;
        }
        ParameterTypeInt parameterTimeMail = new ParameterTypeInt(PARAMETER_PROCESS_DURATION_FOR_MAIL, "Minimum process duration to send emails (in minutes).", 0, Integer.MAX_VALUE, defaultTime);
        parameterTimeMail.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SEND_MAIL, true, 2));
        types.add(parameterTimeMail);
        String encoding = "SYSTEM";
        String encodingProperty = System.getProperty("rapidminer.general.encoding");
        if (encodingProperty != null) {
            encoding = encodingProperty;
        }
        types.add(new ParameterTypeString(PARAMETER_ENCODING, "The encoding of the process XML description.", encoding));
        return types;
    }
}

