/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.clustering.Cluster;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterModel
extends ResultObjectAdapter {
    public static final int UNASSIGNABLE = -1;
    private static final long serialVersionUID = 3780908886210272852L;
    private ArrayList<Cluster> clusters;

    public ClusterModel(int k) {
        this.clusters = new ArrayList(k);
        int i = 0;
        while (i < k) {
            this.clusters.add(new Cluster(i));
            ++i;
        }
    }

    public int getNumberOfClusters() {
        return this.clusters.size();
    }

    public void setClusterAssignments(int[] clusterId, ExampleSet exampleSet) {
        Attribute id = exampleSet.getAttributes().getId();
        if (id.isNominal()) {
            NominalMapping mapping = id.getMapping();
            int i = 0;
            for (Example example : exampleSet) {
                this.getCluster(clusterId[i]).assignExample(mapping.mapIndex((int)example.getValue(id)));
                ++i;
            }
        } else {
            int i = 0;
            for (Example example : exampleSet) {
                this.getCluster(clusterId[i]).assignExample(example.getValue(id));
                ++i;
            }
        }
    }

    public int[] getClusterAssignments(ExampleSet exampleSet) {
        int[] clusterAssignments = new int[exampleSet.size()];
        Attribute idAttribute = exampleSet.getAttributes().getId();
        if (idAttribute.isNominal()) {
            int j = 0;
            for (Example example : exampleSet) {
                clusterAssignments[j] = this.getClusterIndexOfId(example.getValueAsString(idAttribute));
                ++j;
            }
        } else {
            int j = 0;
            for (Example example : exampleSet) {
                clusterAssignments[j] = this.getClusterIndexOfId(example.getValue(idAttribute));
                ++j;
            }
        }
        return clusterAssignments;
    }

    public int getClusterIndexOfId(Object id) {
        int index = 0;
        for (Cluster cluster : this.clusters) {
            if (cluster.containsExampleId(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Cluster getCluster(int i) {
        return this.clusters.get(i);
    }

    public Collection<Cluster> getClusters() {
        return this.clusters;
    }

    @Override
    public String getExtension() {
        return "cm";
    }

    @Override
    public String getFileDescription() {
        return "Cluster model";
    }

    public void checkCapabilities(ExampleSet exampleSet) throws OperatorException {
        Tools.isIdTagged(exampleSet);
    }

    @Override
    public String getName() {
        return "Cluster Model";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int sum = 0;
        int i = 0;
        while (i < this.getNumberOfClusters()) {
            Cluster cl = this.getCluster(i);
            int numObjects = cl.getNumberOfExamples();
            result.append("Cluster " + cl.getClusterId() + ": " + numObjects + " items" + com.rapidminer.tools.Tools.getLineSeparator());
            sum += numObjects;
            ++i;
        }
        result.append("Total number of items: " + sum + com.rapidminer.tools.Tools.getLineSeparator());
        return result.toString();
    }
}

