/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.AbstractModel;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.WekaTools;
import weka.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaClusterModel
extends AbstractModel {
    private static final long serialVersionUID = -8901173604075912094L;
    private final Clusterer clusterer;

    public WekaClusterModel(ExampleSet exampleSet, Clusterer clusterer) {
        super(exampleSet);
        this.clusterer = clusterer;
    }

    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "ClusterInstances", 2);
        this.log("Applying Weka clusterer.");
        int i = 0;
        Attribute clusterAtt = exampleSet.getAttributes().getCluster();
        if (clusterAtt == null) {
            clusterAtt = Tools.createSpecialAttribute(exampleSet, "cluster", 1);
        }
        for (Example e : exampleSet) {
            Instance instance = instances.instance(i++);
            this.applyModelForInstance(instance, e, clusterAtt);
        }
        return exampleSet;
    }

    public void applyModelForInstance(Instance instance, Example e, Attribute clusterAtt) throws OperatorException {
        int cluster = -1;
        try {
            cluster = this.clusterer.clusterInstance(instance);
        }
        catch (Exception exc) {
            throw new UserError(null, (Throwable)exc, 905, this.clusterer, exc.toString());
        }
        e.setValue(clusterAtt, "cluster" + cluster);
    }

    public String toString() {
        return this.clusterer.toString();
    }
}

