/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.features.construction.AbstractGeneratingGeneticAlgorithm;
import com.rapidminer.operator.features.construction.AttributeGenerator;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.features.construction.ExampleSetBasedSelectionMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeNumber;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingGeneticAlgorithm
extends AbstractGeneratingGeneticAlgorithm {
    public static final String PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES = "max_number_of_new_attributes";
    public static final String PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES = "max_total_number_of_attributes";
    public static final String PARAMETER_P_GENERATE = "p_generate";
    public static final String PARAMETER_P_MUTATION = "p_mutation";

    public GeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        double pMutation = this.getParameterAsDouble(PARAMETER_P_MUTATION);
        return new ExampleSetBasedSelectionMutation(pMutation, this.getRandom(), 1, this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES), -1);
    }

    @Override
    protected ExampleSetBasedPopulationOperator getGeneratingPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        List<FeatureGenerator> generators = this.getGenerators();
        if (generators.size() == 0) {
            this.logWarning("No FeatureGenerators specified for " + this.getName() + ".");
        }
        int noOfNewAttributes = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES);
        int totalNoOfNewAttributes = this.getParameterAsInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES);
        double pGenerate = this.getParameterAsDouble(PARAMETER_P_GENERATE);
        return new AttributeGenerator(pGenerate, noOfNewAttributes, totalNoOfNewAttributes, generators, this.getRandom());
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_NEW_ATTRIBUTES, "Max number of attributes to generate for an individual in one generation.", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_TOTAL_NUMBER_OF_ATTRIBUTES, "Max total number of attributes in all generations (-1: no maximum).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P_GENERATE, "Probability for an individual to be selected for generation.", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_P_MUTATION, "Probability for an attribute to be changed (-1: 1 / numberOfAtts).", -1.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

