/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardSelectionOperator
extends OperatorChain {
    public static final String PARAMETER_NUMBER_OF_STEPS = "number_of_steps";

    public ForwardSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSetOriginal = this.getInput(ExampleSet.class);
        ExampleSet exampleSet = (ExampleSet)exampleSetOriginal.clone();
        int numberOfSteps = this.getParameterAsInt(PARAMETER_NUMBER_OF_STEPS);
        int numberOfAttributes = exampleSet.getAttributes().size();
        Attributes attributes = exampleSet.getAttributes();
        Attribute[] attributeArray = new Attribute[numberOfAttributes];
        int i = 0;
        Iterator<Attribute> iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute;
            attributeArray[i] = attribute = iterator.next();
            ++i;
            iterator.remove();
        }
        boolean[] selected = new boolean[numberOfAttributes];
        PerformanceVector bestPerformance = null;
        i = 0;
        while (i < numberOfSteps) {
            int bestIndex = 0;
            boolean gain = false;
            int current = 0;
            while (current < numberOfAttributes) {
                if (!selected[current]) {
                    attributes.addRegular(attributeArray[current]);
                    IOContainer resultContainer = this.applyInnerLearner(exampleSet);
                    PerformanceVector performance = resultContainer.get(PerformanceVector.class);
                    if (bestPerformance == null || performance.compareTo(bestPerformance) > 0) {
                        bestIndex = current;
                        bestPerformance = performance;
                        gain = true;
                    }
                    attributes.remove(attributeArray[current]);
                }
                ++current;
            }
            if (!gain) break;
            attributes.addRegular(attributeArray[bestIndex]);
            selected[bestIndex] = true;
            ++i;
        }
        AttributeWeights weights = new AttributeWeights();
        i = 0;
        Attribute[] attributeArray2 = attributeArray;
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray2[n2];
            if (selected[i]) {
                weights.setWeight(attribute.getName(), 1.0);
            } else {
                weights.setWeight(attribute.getName(), 0.0);
            }
            ++i;
            ++n2;
        }
        return new IOObject[]{exampleSet, bestPerformance, weights};
    }

    public IOContainer applyInnerLearner(IOObject ... objects) throws OperatorException {
        IOContainer input = new IOContainer(objects);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            input = this.getOperator(i).apply(input);
            ++i;
        }
        return input;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_STEPS, "number of forward selection steps", 1, Integer.MAX_VALUE, 10));
        return types;
    }
}

