/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.dialog.AttributeWeightsDialog;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveAttributeWeighting
extends Operator {
    public InteractiveAttributeWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        AttributeWeights weights = null;
        ExampleSet exampleSet = null;
        try {
            weights = this.getInput(AttributeWeights.class);
        }
        catch (MissingIOObjectException e) {
            this.log("No feature weights found in input. Trying to find an example set...");
            weights = new AttributeWeights();
            try {
                exampleSet = this.getInput(ExampleSet.class);
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), 1.0);
                }
                this.log("ExampleSet found! Initially all attributes will be used with weight 1.");
            }
            catch (MissingIOObjectException mioe) {
                this.log("No examples found! Starting dialog without any weights.");
            }
        }
        AttributeWeightsDialog attributeWeightsDialog = new AttributeWeightsDialog(weights);
        attributeWeightsDialog.setVisible(true);
        if (attributeWeightsDialog.isOk()) {
            weights = attributeWeightsDialog.getAttributeWeights();
        }
        if (exampleSet != null) {
            return new IOObject[]{exampleSet, weights};
        }
        return new IOObject[]{weights};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{AttributeWeights.class};
    }
}

