/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.wizards.DBExampleSetWriterConfigurationWizardCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_DATABASE_SYSTEM = "database_system";
    public static final String PARAMETER_DATABASE_URL = "database_url";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";
    public static final String PARAMETER_SET_DEFAULT_VARCHAR_LENGTH = "set_default_varchar_length";
    public static final String PARAMETER_DEFAULT_VARCHAR_LENGTH = "default_varchar_length";

    public DatabaseExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        try {
            DatabaseHandler databaseHandler = this.getConnectedDatabaseHandler();
            databaseHandler.createTable(exampleSet, this.getParameterAsString(PARAMETER_TABLE_NAME), this.getParameterAsInt(PARAMETER_OVERWRITE_MODE), this.getApplyCount() == 0, this.getParameterAsBoolean(PARAMETER_SET_DEFAULT_VARCHAR_LENGTH) ? this.getParameterAsInt(PARAMETER_DEFAULT_VARCHAR_LENGTH) : -1);
            databaseHandler.disconnect();
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
        return exampleSet;
    }

    protected DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String databaseURL = this.getParameterAsString(PARAMETER_DATABASE_URL);
        String username = this.getParameterAsString(PARAMETER_USERNAME);
        String password = this.getParameterAsString(PARAMETER_PASSWORD);
        return DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password, DatabaseService.getJDBCProperties().get(this.getParameterAsInt(PARAMETER_DATABASE_SYSTEM)), this);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeConfiguration(DBExampleSetWriterConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_DATABASE_SYSTEM, "Indicates the used database system", DatabaseService.getDBSystemNames(), 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DATABASE_URL, "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "Database username.", false));
        types.add(new ParameterTypePassword(PARAMETER_PASSWORD, "Password for the database."));
        types.add(new ParameterTypeString(PARAMETER_TABLE_NAME, "Use this table if work_on_database is true or no other query is specified.", false));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", DatabaseHandler.OVERWRITE_MODES, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_SET_DEFAULT_VARCHAR_LENGTH, "Set varchar columns to default length.", false));
        type = new ParameterTypeInt(PARAMETER_DEFAULT_VARCHAR_LENGTH, "Default length of varchar columns.", 0, Integer.MAX_VALUE, 128);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SET_DEFAULT_VARCHAR_LENGTH, true, true));
        types.add(type);
        return types;
    }
}

