/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.operator.learner.functions.kernel.evosvm.OptimizationFunction;
import com.rapidminer.tools.math.kernels.Kernel;

public class RegressionOptimizationFunction
implements OptimizationFunction {
    private double epsilon;

    public RegressionOptimizationFunction(double epsilon) {
        this.epsilon = epsilon;
    }

    public double[] getFitness(double[] alphas, double[] ys, Kernel kernel) {
        int offset = ys.length;
        double matrixSum = 0.0;
        int i = 0;
        while (i < ys.length) {
            int j = 0;
            while (j < ys.length) {
                matrixSum += (alphas[i] - alphas[i + offset]) * (alphas[j] - alphas[j + offset]) * kernel.getDistance(i, j);
                ++j;
            }
            ++i;
        }
        double alphaSum = 0.0;
        int i2 = 0;
        while (i2 < ys.length) {
            alphaSum += alphas[i2] + alphas[i2 + offset];
            ++i2;
        }
        double labelSum = 0.0;
        int i3 = 0;
        while (i3 < ys.length) {
            labelSum += ys[i3] * (alphas[i3] - alphas[i3 + offset]);
            ++i3;
        }
        return new double[]{-0.5 * matrixSum - this.epsilon * alphaSum + labelSum, 0.0};
    }
}

